package de.fhdw.gaming.ipspiel24.fg.domain.factory;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;

/**
 * Implements {@Link FGStrategyFactoryProvider} by using the {@Link ServiceLoader}.
 */
public final class FGDefaultStrategyFactoryProvider implements FGStrategyFactoryProvider {

    @Override
    public List<FGStrategyFactory> getStrategyFactories() {
        final ServiceLoader<FGStrategyFactory> services = ServiceLoader.load(FGStrategyFactory.class);
        final List<FGStrategyFactory> list = new ArrayList<>();
        services.iterator().forEachRemaining(list::add);
        return list;
    }
    
}
