/*
 * Copyright © 2020-2023 Fachhochschule für die Wirtschaft (FHDW) Hannover
 *
 * This file is part of othello-core.
 *
 * Othello-core is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Othello-core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with othello-core.  If not, see <http://www.gnu.org/licenses/>.
 */
package de.fhdw.gaming.ipspiel24.muenzwurf.core.domain;

import de.fhdw.gaming.core.domain.GameBuilderFactory;
import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.ui.InputProvider;

/**
 * An Othello {@link GameBuilderFactory} which allows to create an Othello game builder.
 */
public interface MuenzwurfGameBuilderFactory extends GameBuilderFactory {
    
    /**
     * Player's outcome on no/yes.
     */
    String PARAM_PLAYER_OUTCOME_ON_HEADS_TAILS = "playerOutcomeOnHeadsTails";

    /**
     * Player's outcome on no/yes.
     */
    String PARAM_PLAYER_OUTCOME_ON_TAILS_HEADS = "playerOutcomeOnTailsHeads";

    /**
     * Player's outcome on no/no.
     */
    String PARAM_PLAYER_OUTCOME_ON_TAILS_TAILS = "playerOutcomeOnTailsTails";
    
    /**
     * Player's outcome on no/yes.
     */
    String PARAM_PLAYER_OUTCOME_ON_HEADS_HEADS = "playerOutcomeOnHeadsHeads";

    /**
     * Player's outcome on no/yes.
     */
    String PARAM_PLAYER_OUTCOME_ON_EDGE_HEADS = "playerOutcomeOnEdgeHeads";
    
    /**
     * Player's outcome on no/yes.
     */
    String PARAM_PLAYER_OUTCOME_ON_HEADS_EDGE = "playerOutcomeOnHeadsEdge";
    
    /**
     * Player's outcome on no/yes.
     */
    String PARAM_PLAYER_OUTCOME_ON_EDGE_TAILS = "playerOutcomeOnEdgeTails";
    
    /**
     * Player's outcome on no/yes.
     */
    String PARAM_PLAYER_OUTCOME_ON_TAILS_EDGE = "playerOutcomeOnTailsEdge";
    
    /**
     * Player's outcome on no/yes.
     */
    String PARAM_PLAYER_OUTCOME_ON_EDGE_EDGE = "playerOutcomeOnEdgeEdge";
    
    /**
     * Whether the play gains points when the result is the same.
     */
    String PARAM_PLAYER_POINTGAIN_ON_SAME_RESULT = "playerGetsPointsOnSameResult";
    
    
    @Override
    MuenzwurfGameBuilder createGameBuilder(InputProvider inputProvider) throws GameException;
}
