/*
 * Copyright © 2021-2023 Fachhochschule für die Wirtschaft (FHDW) Hannover
 *
 * This file is part of ipspiel24-demo.
 *
 * Ipspiel24-demo is free software: you can redistribute it and/or modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * Ipspiel24-demo is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with ipspiel24-demo. If not, see
 * <http://www.gnu.org/licenses/>.
 */
package de.fhdw.gaming.ipspiel24.muenzwurf.core.strategy;

import java.util.Optional;

import de.fhdw.gaming.ipspiel24.muenzwurf.core.domain.MuenzwurfPlayer;
import de.fhdw.gaming.ipspiel24.muenzwurf.core.domain.MuenzwurfState;
import de.fhdw.gaming.ipspiel24.muenzwurf.core.domain.MuenzwurfStrategy;
import de.fhdw.gaming.ipspiel24.muenzwurf.core.moves.MuenzwurfMove;
import de.fhdw.gaming.ipspiel24.muenzwurf.core.moves.factory.MuenzwurfMoveFactory;

/**
 * Implements {@link DemoStrategy} by always saying "no".
 */
public final class MuenzwurfChooseTailsStrategy implements MuenzwurfStrategy {

    /**
     * The factory for creating Demo moves.
     */
    private final MuenzwurfMoveFactory moveFactory;

    /**
     * Creates an {@link MuenzwurfChooseTailsStrategy}.
     *
     * @param moveFactory The factory for creating Demo moves.
     */
    MuenzwurfChooseTailsStrategy(final MuenzwurfMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    @Override
    public Optional<MuenzwurfMove> computeNextMove(
            final int gameId,
            final MuenzwurfPlayer player,
            final MuenzwurfState state,
            final long maxComputationTimePerMove) {
        return Optional.of(this.moveFactory.createTailsMove());
    }

    @Override
    public String toString() {
        return MuenzwurfChooseTailsStrategy.class.getSimpleName();
    }
}
