package de.fhdw.gaming.ipspiel24.muenzwurf.core.moves.impl;

import de.fhdw.gaming.ipspiel24.muenzwurf.core.moves.MuenzwurfMove;

/**
 * Represents a move allowed by the rules of the game.
 * <p>
 * The purpose of this class is solely to be able to check whether a {@link DemoMove} implementation is allowed by the
 * rules of the game. As this class is not public, custom strategies are unable to create {@link DemoMove} objects that
 * inherit from this class, so custom moves can be distinguished from possible moves easily.
 */
public abstract class AbstractMuenzwurfMove implements MuenzwurfMove {

    /**
     * Protected constructor.
     */
    protected AbstractMuenzwurfMove() {
        // nothing to do
    }
}
