/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel24.muenzwurf.core.domain.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel24.muenzwurf.core.domain.MuenzwurfPlayer;
import de.fhdw.gaming.ipspiel24.muenzwurf.core.domain.MuenzwurfPlayerBuilder;
import de.fhdw.gaming.ipspiel24.muenzwurf.core.domain.MuenzwurfSide;
import de.fhdw.gaming.ipspiel24.muenzwurf.core.domain.impl.MuenzwurfPlayerImpl;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

final class MuenzwurfPlayerBuilderImpl
implements MuenzwurfPlayerBuilder {
    private Optional<String> name = Optional.empty();
    private Optional<Map<MuenzwurfSide, Map<MuenzwurfSide, Double>>> possibleOutcomes = Optional.empty();

    MuenzwurfPlayerBuilderImpl() {
    }

    @Override
    public MuenzwurfPlayerBuilderImpl changeName(String newName) {
        this.name = Optional.of(newName);
        return this;
    }

    @Override
    public MuenzwurfPlayerBuilder changePossibleOutcomes(Map<MuenzwurfSide, Map<MuenzwurfSide, Double>> newPossibleOutcomes) {
        this.possibleOutcomes = Optional.of(newPossibleOutcomes);
        return this;
    }

    @Override
    public MuenzwurfPlayer build() throws GameException {
        return new MuenzwurfPlayerImpl(this.name.orElseThrow(), this.checkPossibleOutcomes(this.possibleOutcomes.orElseThrow()));
    }

    private Map<MuenzwurfSide, Map<MuenzwurfSide, Double>> checkPossibleOutcomes(Map<MuenzwurfSide, Map<MuenzwurfSide, Double>> outcomes) {
        this.checkPossibleOutcome(outcomes, MuenzwurfSide.TAILS, MuenzwurfSide.TAILS);
        this.checkPossibleOutcome(outcomes, MuenzwurfSide.TAILS, MuenzwurfSide.HEADS);
        this.checkPossibleOutcome(outcomes, MuenzwurfSide.HEADS, MuenzwurfSide.TAILS);
        this.checkPossibleOutcome(outcomes, MuenzwurfSide.HEADS, MuenzwurfSide.HEADS);
        return outcomes;
    }

    private void checkPossibleOutcome(Map<MuenzwurfSide, Map<MuenzwurfSide, Double>> outcomes, MuenzwurfSide firstChoice, MuenzwurfSide secondChoice) {
        if (outcomes.getOrDefault((Object)firstChoice, Collections.emptyMap()).get((Object)secondChoice) == null) {
            throw new IllegalArgumentException(String.format("No outcome defined for player '%s' and combination %s/%s.", this.name, MuenzwurfPlayerBuilderImpl.toAnswer(firstChoice), MuenzwurfPlayerBuilderImpl.toAnswer(secondChoice)));
        }
    }

    private static String toAnswer(MuenzwurfSide value) {
        return value == MuenzwurfSide.HEADS ? "Heads" : "Tails";
    }
}

