/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel24.muenzwurf.core.domain.impl;

import de.fhdw.gaming.core.domain.DefaultGame;
import de.fhdw.gaming.core.domain.Game;
import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.MoveGenerator;
import de.fhdw.gaming.core.domain.Observer;
import de.fhdw.gaming.core.domain.State;
import de.fhdw.gaming.ipspiel24.muenzwurf.core.domain.MuenzwurfGameBuilder;
import de.fhdw.gaming.ipspiel24.muenzwurf.core.domain.MuenzwurfPlayer;
import de.fhdw.gaming.ipspiel24.muenzwurf.core.domain.MuenzwurfPlayerBuilder;
import de.fhdw.gaming.ipspiel24.muenzwurf.core.domain.MuenzwurfState;
import de.fhdw.gaming.ipspiel24.muenzwurf.core.domain.MuenzwurfStrategy;
import de.fhdw.gaming.ipspiel24.muenzwurf.core.domain.impl.MuenzwurfMoveGeneratorImpl;
import de.fhdw.gaming.ipspiel24.muenzwurf.core.domain.impl.MuenzwurfPlayerBuilderImpl;
import de.fhdw.gaming.ipspiel24.muenzwurf.core.domain.impl.MuenzwurfStateImpl;
import de.fhdw.gaming.ipspiel24.muenzwurf.core.moves.MuenzwurfMove;
import de.fhdw.gaming.ipspiel24.muenzwurf.core.moves.impl.AbstractMuenzwurfMove;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

final class MuenzwurfGameBuilderImpl
implements MuenzwurfGameBuilder {
    private final List<Observer> observers = new ArrayList<Observer>();
    private Optional<MuenzwurfPlayer> firstPlayer = Optional.empty();
    private Optional<MuenzwurfStrategy> firstPlayerStrategy = Optional.empty();
    private Optional<MuenzwurfPlayer> secondPlayer = Optional.empty();
    private Optional<MuenzwurfStrategy> secondPlayerStrategy = Optional.empty();
    private int maxComputationTimePerMove = 5;

    MuenzwurfGameBuilderImpl() {
    }

    @Override
    public MuenzwurfPlayerBuilder createPlayerBuilder() {
        return new MuenzwurfPlayerBuilderImpl();
    }

    @Override
    public MuenzwurfGameBuilder addPlayer(MuenzwurfPlayer player, MuenzwurfStrategy strategy) throws GameException {
        if (this.firstPlayer.isEmpty()) {
            this.firstPlayer = Optional.of(Objects.requireNonNull(player, "player"));
            this.firstPlayerStrategy = Optional.of(Objects.requireNonNull(strategy, "firstPlayerStrategy"));
        } else if (this.secondPlayer.isEmpty()) {
            this.secondPlayer = Optional.of(Objects.requireNonNull(player, "player"));
            this.secondPlayerStrategy = Optional.of(Objects.requireNonNull(strategy, "secondPlayerStrategy"));
        } else {
            throw new GameException(String.format("More than two players are now allowed.", new Object[0]));
        }
        return this;
    }

    public MuenzwurfGameBuilder changeMaximumComputationTimePerMove(int newMaxComputationTimePerMove) {
        this.maxComputationTimePerMove = newMaxComputationTimePerMove;
        return this;
    }

    @Override
    public MuenzwurfGameBuilder addObservers(List<Observer> newObservers) {
        this.observers.addAll(newObservers);
        return this;
    }

    @Override
    public Game<MuenzwurfPlayer, MuenzwurfState, MuenzwurfMove, MuenzwurfStrategy> build(int id) throws GameException, InterruptedException {
        if (!this.firstPlayer.isPresent() || !this.secondPlayer.isPresent()) {
            throw new GameException("A Muenzwurf game needs two players.");
        }
        MuenzwurfStateImpl initialState = new MuenzwurfStateImpl(this.firstPlayer.get(), this.secondPlayer.get());
        LinkedHashMap<String, MuenzwurfStrategy> strategies = new LinkedHashMap<String, MuenzwurfStrategy>();
        strategies.put(initialState.getFirstPlayer().getName(), this.firstPlayerStrategy.orElseThrow());
        strategies.put(initialState.getSecondPlayer().getName(), this.secondPlayerStrategy.orElseThrow());
        return new DefaultGame(id, (State)initialState, strategies, (long)this.maxComputationTimePerMove, AbstractMuenzwurfMove.class::isInstance, (MoveGenerator)new MuenzwurfMoveGeneratorImpl(), this.observers);
    }
}

