/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel24.ssp.domain.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.Strategy;
import de.fhdw.gaming.core.ui.InputProvider;
import de.fhdw.gaming.core.ui.InputProviderException;
import de.fhdw.gaming.core.ui.type.validator.MaxValueValidator;
import de.fhdw.gaming.core.ui.type.validator.MinValueValidator;
import de.fhdw.gaming.core.ui.type.validator.PatternValidator;
import de.fhdw.gaming.core.ui.type.validator.Validator;
import de.fhdw.gaming.ipspiel24.ssp.domain.SspGameBuilder;
import de.fhdw.gaming.ipspiel24.ssp.domain.SspGameBuilderFactory;
import de.fhdw.gaming.ipspiel24.ssp.domain.SspPlayer;
import de.fhdw.gaming.ipspiel24.ssp.domain.SspPlayerBuilder;
import de.fhdw.gaming.ipspiel24.ssp.domain.SspPossibleChoice;
import de.fhdw.gaming.ipspiel24.ssp.domain.SspStrategy;
import de.fhdw.gaming.ipspiel24.ssp.domain.factory.SspDefaultStrategyFactoryProvider;
import de.fhdw.gaming.ipspiel24.ssp.domain.factory.SspStrategyFactory;
import de.fhdw.gaming.ipspiel24.ssp.domain.factory.SspStrategyFactoryProvider;
import de.fhdw.gaming.ipspiel24.ssp.domain.impl.SspGameBuilderImpl;
import de.fhdw.gaming.ipspiel24.ssp.moves.impl.SspDefaultMoveFactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;

public final class SspGameBuilderFactoryImpl
implements SspGameBuilderFactory {
    private static final int NUMBER_OF_PLAYERS = 2;
    private static final int MIN_MAX_COMPUTATION_TIME_PER_MOVE = 1;
    private static final int MAX_MAX_COMPUTATION_TIME_PER_MOVE = 3600;
    private final Set<SspStrategy> strategies;

    public SspGameBuilderFactoryImpl() {
        this(new SspDefaultStrategyFactoryProvider());
    }

    SspGameBuilderFactoryImpl(SspStrategyFactoryProvider strategyFactoryProvider) {
        SspDefaultMoveFactory moveFactory = new SspDefaultMoveFactory();
        List<SspStrategyFactory> factories = strategyFactoryProvider.getStrategyFactories();
        this.strategies = new LinkedHashSet<SspStrategy>();
        for (SspStrategyFactory factory : factories) {
            this.strategies.add(factory.create(moveFactory));
        }
    }

    public String getName() {
        return "Ssp";
    }

    public int getMinimumNumberOfPlayers() {
        return 2;
    }

    public int getMaximumNumberOfPlayers() {
        return 2;
    }

    public List<? extends Strategy<?, ?, ?>> getStrategies() {
        return new ArrayList<SspStrategy>(this.strategies);
    }

    @Override
    public SspGameBuilder createGameBuilder(InputProvider inputProvider) throws GameException {
        try {
            SspGameBuilderImpl gameBuilder = new SspGameBuilderImpl();
            Map gameData = inputProvider.needInteger("maxComputationTimePerMove", "Maximum computation time per move in seconds", Optional.of(5), new Validator[]{new MinValueValidator((Comparable)Integer.valueOf(1)), new MaxValueValidator((Comparable)Integer.valueOf(3600))}).requestData("Game properties");
            gameBuilder.changeMaximumComputationTimePerMove((Integer)gameData.get("maxComputationTimePerMove"));
            InputProvider firstPlayerInputProvider = inputProvider.getNext(gameData);
            Map<String, Object> firstPlayerData = this.requestPlayerData(firstPlayerInputProvider, "Player 1");
            SspPlayer firstPlayer = this.createPlayer(gameBuilder.createPlayerBuilder(), firstPlayerData);
            SspStrategy firstPlayerStrategy = this.getStrategy(firstPlayerData);
            gameBuilder.addPlayer(firstPlayer, firstPlayerStrategy);
            InputProvider secondPlayerInputProvider = firstPlayerInputProvider.getNext(firstPlayerData);
            Map<String, Object> secondPlayerData = this.requestPlayerData(secondPlayerInputProvider, "Player 2");
            SspPlayer secondPlayer = this.createPlayer(gameBuilder.createPlayerBuilder(), secondPlayerData);
            SspStrategy secondPlayerStrategy = this.getStrategy(secondPlayerData);
            gameBuilder.addPlayer(secondPlayer, secondPlayerStrategy);
            return gameBuilder;
        }
        catch (InputProviderException e) {
            throw new GameException(String.format("Creating Ssp game was aborted: %s", e.getMessage()), (Throwable)e);
        }
    }

    private Map<String, Object> requestPlayerData(InputProvider inputProvider, String title) throws GameException, InputProviderException {
        inputProvider.needString("playerName", "Name", Optional.empty(), new Validator[]{new PatternValidator(Pattern.compile("\\S+(\\s+\\S+)*"))}).needInteger("playerOutcomeOnRockRock", "Player's outcome on Rock/Rock", Optional.of(0), new Validator[0]).needInteger("playerOutcomeOnRockPaper", "Player's outcome on Rock/Paper", Optional.of(-1), new Validator[0]).needInteger("playerOutcomeOnRockScissors", "Player's outcome on Rock/Scissors", Optional.of(1), new Validator[0]).needInteger("playerOutcomeOnPaperRock", "Player's outcome on Paper/Rock", Optional.of(1), new Validator[0]).needInteger("playerOutcomeOnPaperPaper", "Player's outcome on Paper/Paper", Optional.of(0), new Validator[0]).needInteger("playerOutcomeOnPaperScissors", "Player's outcome on Paper/Scissors", Optional.of(-1), new Validator[0]).needInteger("playerOutcomeOnScissorsRock", "Player's outcome on Scissors/Rock", Optional.of(-1), new Validator[0]).needInteger("playerOutcomeOnScissorsPaper", "Player's outcome on Scissors/Paper", Optional.of(1), new Validator[0]).needInteger("playerOutcomeOnScissorsScissors", "Player's outcome on Scissors/Scissors", Optional.of(0), new Validator[0]).needObject("playerStrategy", "Strategy", Optional.empty(), this.strategies);
        return inputProvider.requestData(title);
    }

    private SspPlayer createPlayer(SspPlayerBuilder playerBuilder, Map<String, Object> playerData) throws GameException, InputProviderException {
        LinkedHashMap<SspPossibleChoice, Map<SspPossibleChoice, Double>> possibleOutcomes = new LinkedHashMap<SspPossibleChoice, Map<SspPossibleChoice, Double>>();
        LinkedHashMap<SspPossibleChoice, Double> possibleOutcomesRock = new LinkedHashMap<SspPossibleChoice, Double>();
        possibleOutcomesRock.put(SspPossibleChoice.SPC_ROCK, Double.valueOf(((Integer)playerData.get("playerOutcomeOnRockRock")).intValue()));
        possibleOutcomesRock.put(SspPossibleChoice.SPC_PAPER, Double.valueOf(((Integer)playerData.get("playerOutcomeOnRockPaper")).intValue()));
        possibleOutcomesRock.put(SspPossibleChoice.SPC_SCISSORS, Double.valueOf(((Integer)playerData.get("playerOutcomeOnRockScissors")).intValue()));
        possibleOutcomes.put(SspPossibleChoice.SPC_ROCK, possibleOutcomesRock);
        LinkedHashMap<SspPossibleChoice, Double> possibleOutcomesPaper = new LinkedHashMap<SspPossibleChoice, Double>();
        possibleOutcomesPaper.put(SspPossibleChoice.SPC_ROCK, Double.valueOf(((Integer)playerData.get("playerOutcomeOnPaperRock")).intValue()));
        possibleOutcomesPaper.put(SspPossibleChoice.SPC_PAPER, Double.valueOf(((Integer)playerData.get("playerOutcomeOnPaperPaper")).intValue()));
        possibleOutcomesPaper.put(SspPossibleChoice.SPC_SCISSORS, Double.valueOf(((Integer)playerData.get("playerOutcomeOnPaperScissors")).intValue()));
        possibleOutcomes.put(SspPossibleChoice.SPC_PAPER, possibleOutcomesPaper);
        LinkedHashMap<SspPossibleChoice, Double> possibleOutcomesScissors = new LinkedHashMap<SspPossibleChoice, Double>();
        possibleOutcomesScissors.put(SspPossibleChoice.SPC_ROCK, Double.valueOf(((Integer)playerData.get("playerOutcomeOnScissorsRock")).intValue()));
        possibleOutcomesScissors.put(SspPossibleChoice.SPC_PAPER, Double.valueOf(((Integer)playerData.get("playerOutcomeOnScissorsPaper")).intValue()));
        possibleOutcomesScissors.put(SspPossibleChoice.SPC_SCISSORS, Double.valueOf(((Integer)playerData.get("playerOutcomeOnScissorsScissors")).intValue()));
        possibleOutcomes.put(SspPossibleChoice.SPC_SCISSORS, possibleOutcomesScissors);
        return playerBuilder.changeName((String)playerData.get("playerName")).changePossibleOutcomes(possibleOutcomes).build();
    }

    private SspStrategy getStrategy(Map<String, Object> playerData) {
        return (SspStrategy)playerData.get("playerStrategy");
    }
}

