/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel24.tictactoe.gui.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel24.tictactoe.core.domain.TicTacToePlayer;
import de.fhdw.gaming.ipspiel24.tictactoe.core.domain.TicTacToeState;
import de.fhdw.gaming.ipspiel24.tictactoe.core.domain.TicTacToeStrategy;
import de.fhdw.gaming.ipspiel24.tictactoe.core.moves.TicTacToeMove;
import de.fhdw.gaming.ipspiel24.tictactoe.core.moves.factory.TicTacToeMoveFactory;
import de.fhdw.gaming.ipspiel24.tictactoe.gui.TicTacToeBoardEventProvider;
import de.fhdw.gaming.ipspiel24.tictactoe.gui.impl.TicTacToeGuiObserverImpl;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

public final class TicTacToeInteractiveStrategy
implements TicTacToeStrategy {
    private final TicTacToeMoveFactory moveFactory;

    TicTacToeInteractiveStrategy(TicTacToeMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    public Optional<TicTacToeMove> computeNextMove(int gameId, TicTacToePlayer player, TicTacToeState state, long maxComputationTimePerMove) throws GameException {
        Optional<TicTacToeBoardEventProvider> provider = TicTacToeGuiObserverImpl.getEventProvider(gameId);
        if (provider.isEmpty()) {
            return Optional.empty();
        }
        AtomicReference move = new AtomicReference();
        provider.get().waitForEvent(player, state).accept(event -> move.setPlain(this.moveFactory.createPlaceMarkMove(player.isUsingCrosses(), event.getFieldPosition())));
        return Optional.ofNullable((TicTacToeMove)move.getPlain());
    }

    public String toString() {
        return TicTacToeInteractiveStrategy.class.getSimpleName();
    }

    public boolean isInteractive() {
        return true;
    }

    public void abortRequested(int gameId) {
        Optional<TicTacToeBoardEventProvider> provider = TicTacToeGuiObserverImpl.getEventProvider(gameId);
        if (!provider.isEmpty()) {
            provider.get().cancelWaiting();
        }
    }
}

