/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel24.tictactoe.gui.impl;

import de.fhdw.gaming.core.domain.Game;
import de.fhdw.gaming.gui.GuiObserver;
import de.fhdw.gaming.ipspiel24.tictactoe.core.domain.TicTacToePlayer;
import de.fhdw.gaming.ipspiel24.tictactoe.core.domain.TicTacToeState;
import de.fhdw.gaming.ipspiel24.tictactoe.core.domain.TicTacToeStrategy;
import de.fhdw.gaming.ipspiel24.tictactoe.core.moves.TicTacToeMove;
import de.fhdw.gaming.ipspiel24.tictactoe.gui.TicTacToeBoardEventProvider;
import de.fhdw.gaming.ipspiel24.tictactoe.gui.impl.TicTacToeBoardEventProviderImpl;
import de.fhdw.gaming.ipspiel24.tictactoe.gui.impl.TicTacToeBoardView;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javafx.scene.Node;

final class TicTacToeGuiObserverImpl
implements GuiObserver {
    private static final AtomicReference<WeakReference<TicTacToeGuiObserverImpl>> INSTANCE = new AtomicReference();
    private final Map<Integer, TicTacToeBoardView> boardViews;

    TicTacToeGuiObserverImpl() {
        INSTANCE.compareAndSet(null, new WeakReference<TicTacToeGuiObserverImpl>(this));
        this.boardViews = new LinkedHashMap<Integer, TicTacToeBoardView>();
    }

    static Optional<TicTacToeBoardEventProvider> getEventProvider(int gameId) {
        TicTacToeGuiObserverImpl instance = Optional.ofNullable(INSTANCE.get()).map(Reference::get).orElse(null);
        if (instance == null) {
            return Optional.empty();
        }
        TicTacToeBoardView boardView = instance.boardViews.get(gameId);
        return boardView == null ? Optional.empty() : Optional.of(new TicTacToeBoardEventProviderImpl(boardView));
    }

    public Optional<Node> gameCreated(Game<?, ?, ?, ?> game) {
        Optional<Game<TicTacToePlayer, TicTacToeState, TicTacToeMove, TicTacToeStrategy>> ticTacToeGame = TicTacToeGuiObserverImpl.toTicTacToeGame(game);
        if (ticTacToeGame.isPresent()) {
            TicTacToeBoardView boardView = new TicTacToeBoardView(ticTacToeGame.get());
            this.boardViews.put(game.getId(), boardView);
            return Optional.of(boardView.getNode());
        }
        return Optional.empty();
    }

    public void gamePaused(Game<?, ?, ?, ?> game) {
        TicTacToeBoardView boardView;
        Optional<Game<TicTacToePlayer, TicTacToeState, TicTacToeMove, TicTacToeStrategy>> ticTacToeGame = TicTacToeGuiObserverImpl.toTicTacToeGame(game);
        if (ticTacToeGame.isPresent() && (boardView = this.boardViews.get(game.getId())) != null) {
            boardView.gamePaused(ticTacToeGame.get());
        }
    }

    public void gameResumed(Game<?, ?, ?, ?> game) {
        TicTacToeBoardView boardView;
        Optional<Game<TicTacToePlayer, TicTacToeState, TicTacToeMove, TicTacToeStrategy>> ticTacToeGame = TicTacToeGuiObserverImpl.toTicTacToeGame(game);
        if (ticTacToeGame.isPresent() && (boardView = this.boardViews.get(game.getId())) != null) {
            boardView.gameResumed(ticTacToeGame.get());
        }
    }

    public void gameDestroyed(Game<?, ?, ?, ?> game) {
        TicTacToeBoardView boardView;
        Optional<Game<TicTacToePlayer, TicTacToeState, TicTacToeMove, TicTacToeStrategy>> ticTacToeGame = TicTacToeGuiObserverImpl.toTicTacToeGame(game);
        if (ticTacToeGame.isPresent() && (boardView = this.boardViews.remove(game.getId())) != null) {
            boardView.destroy(ticTacToeGame.get());
        }
    }

    private static Optional<Game<TicTacToePlayer, TicTacToeState, TicTacToeMove, TicTacToeStrategy>> toTicTacToeGame(Game<?, ?, ?, ?> game) {
        if (game.getState() instanceof TicTacToeState) {
            Game<?, ?, ?, ?> othelloGame = game;
            return Optional.of(othelloGame);
        }
        return Optional.empty();
    }
}

