/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel24.muenzwurf.core.domain.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.Strategy;
import de.fhdw.gaming.core.ui.InputProvider;
import de.fhdw.gaming.core.ui.InputProviderException;
import de.fhdw.gaming.core.ui.type.validator.MaxValueValidator;
import de.fhdw.gaming.core.ui.type.validator.MinValueValidator;
import de.fhdw.gaming.core.ui.type.validator.PatternValidator;
import de.fhdw.gaming.core.ui.type.validator.Validator;
import de.fhdw.gaming.ipspiel24.muenzwurf.core.domain.MuenzwurfGameBuilder;
import de.fhdw.gaming.ipspiel24.muenzwurf.core.domain.MuenzwurfGameBuilderFactory;
import de.fhdw.gaming.ipspiel24.muenzwurf.core.domain.MuenzwurfPlayer;
import de.fhdw.gaming.ipspiel24.muenzwurf.core.domain.MuenzwurfPlayerBuilder;
import de.fhdw.gaming.ipspiel24.muenzwurf.core.domain.MuenzwurfSide;
import de.fhdw.gaming.ipspiel24.muenzwurf.core.domain.MuenzwurfStrategy;
import de.fhdw.gaming.ipspiel24.muenzwurf.core.domain.factory.MuenzwurfDefaultStrategyFactoryProvider;
import de.fhdw.gaming.ipspiel24.muenzwurf.core.domain.factory.MuenzwurfStrategyFactory;
import de.fhdw.gaming.ipspiel24.muenzwurf.core.domain.factory.MuenzwurfStrategyFactoryProvider;
import de.fhdw.gaming.ipspiel24.muenzwurf.core.domain.impl.MuenzwurfGameBuilderImpl;
import de.fhdw.gaming.ipspiel24.muenzwurf.core.moves.impl.MuenzwurfDefaultMoveFactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;

public final class MuenzwurfGameBuilderFactoryImpl
implements MuenzwurfGameBuilderFactory {
    private static final int NUMBER_OF_PLAYERS = 2;
    private static final int MIN_MAX_COMPUTATION_TIME_PER_MOVE = 1;
    private static final int MAX_MAX_COMPUTATION_TIME_PER_MOVE = 3600;
    private final Set<MuenzwurfStrategy> strategies;

    public MuenzwurfGameBuilderFactoryImpl() {
        this(new MuenzwurfDefaultStrategyFactoryProvider());
    }

    MuenzwurfGameBuilderFactoryImpl(MuenzwurfStrategyFactoryProvider strategyFactoryProvider) {
        MuenzwurfDefaultMoveFactory moveFactory = new MuenzwurfDefaultMoveFactory();
        List<MuenzwurfStrategyFactory> factories = strategyFactoryProvider.getStrategyFactories();
        this.strategies = new LinkedHashSet<MuenzwurfStrategy>();
        for (MuenzwurfStrategyFactory factory : factories) {
            this.strategies.add(factory.create(moveFactory));
        }
    }

    public String getName() {
        return "Muenzwurf";
    }

    public int getMinimumNumberOfPlayers() {
        return 2;
    }

    public int getMaximumNumberOfPlayers() {
        return 2;
    }

    public List<? extends Strategy<?, ?, ?>> getStrategies() {
        return new ArrayList<MuenzwurfStrategy>(this.strategies);
    }

    @Override
    public MuenzwurfGameBuilder createGameBuilder(InputProvider inputProvider) throws GameException {
        try {
            MuenzwurfGameBuilderImpl gameBuilder = new MuenzwurfGameBuilderImpl();
            Map gameData = inputProvider.needInteger("maxComputationTimePerMove", "Maximum computation time per move in seconds", Optional.of(5), new Validator[]{new MinValueValidator((Comparable)Integer.valueOf(1)), new MaxValueValidator((Comparable)Integer.valueOf(3600))}).requestData("Game properties");
            gameBuilder.changeMaximumComputationTimePerMove((Integer)gameData.get("maxComputationTimePerMove"));
            InputProvider firstPlayerInputProvider = inputProvider.getNext(gameData);
            Map<String, Object> firstPlayerData = this.requestPlayerData(firstPlayerInputProvider, "Player 1", Optional.empty());
            MuenzwurfPlayer firstPlayer = this.createPlayer(gameBuilder.createPlayerBuilder(), firstPlayerData);
            MuenzwurfStrategy firstPlayerStrategy = this.getStrategy(firstPlayerData);
            gameBuilder.addPlayer(firstPlayer, firstPlayerStrategy);
            InputProvider secondPlayerInputProvider = firstPlayerInputProvider.getNext(firstPlayerData);
            Map<String, Object> secondPlayerData = this.requestPlayerData(secondPlayerInputProvider, "Player 2", Optional.of((Boolean)firstPlayerData.get("playerGetsPointsOnSameResult") == false));
            MuenzwurfPlayer secondPlayer = this.createPlayer(gameBuilder.createPlayerBuilder(), secondPlayerData);
            MuenzwurfStrategy secondPlayerStrategy = this.getStrategy(secondPlayerData);
            gameBuilder.addPlayer(secondPlayer, secondPlayerStrategy);
            return gameBuilder;
        }
        catch (InputProviderException e) {
            throw new GameException(String.format("Creating Muenzwurf game was aborted: %s", e.getMessage()), (Throwable)e);
        }
    }

    private Map<String, Object> requestPlayerData(InputProvider inputProvider, String title, Optional<Boolean> pointsOnSame) throws GameException, InputProviderException {
        inputProvider.needString("playerName", "Name", Optional.empty(), new Validator[]{new PatternValidator(Pattern.compile("\\S+(\\s+\\S+)*"))}).needBoolean("playerGetsPointsOnSameResult", "Player gets points on same result", Optional.of(Boolean.TRUE), new Validator[0]).needObject("playerStrategy", "Strategy", Optional.empty(), this.strategies);
        if (pointsOnSame.isPresent()) {
            inputProvider.fixedBoolean("playerGetsPointsOnSameResult", pointsOnSame.get());
        }
        return inputProvider.requestData(title);
    }

    private MuenzwurfPlayer createPlayer(MuenzwurfPlayerBuilder playerBuilder, Map<String, Object> playerData) throws GameException, InputProviderException {
        LinkedHashMap<MuenzwurfSide, Map<MuenzwurfSide, Double>> possibleOutcomes = new LinkedHashMap<MuenzwurfSide, Map<MuenzwurfSide, Double>>();
        LinkedHashMap<MuenzwurfSide, Double> possibleOutcomesTails = new LinkedHashMap<MuenzwurfSide, Double>();
        LinkedHashMap<MuenzwurfSide, Double> possibleOutcomesHeads = new LinkedHashMap<MuenzwurfSide, Double>();
        LinkedHashMap<MuenzwurfSide, Double> possibleOutcomesEdge = new LinkedHashMap<MuenzwurfSide, Double>();
        if (((Boolean)playerData.get("playerGetsPointsOnSameResult")).booleanValue()) {
            possibleOutcomesTails.put(MuenzwurfSide.TAILS, 1.0);
            possibleOutcomesTails.put(MuenzwurfSide.HEADS, -1.0);
            possibleOutcomesTails.put(MuenzwurfSide.EDGE, -1.0);
            possibleOutcomes.put(MuenzwurfSide.TAILS, possibleOutcomesTails);
            possibleOutcomesHeads.put(MuenzwurfSide.TAILS, -1.0);
            possibleOutcomesHeads.put(MuenzwurfSide.HEADS, 1.0);
            possibleOutcomesHeads.put(MuenzwurfSide.EDGE, -1.0);
            possibleOutcomes.put(MuenzwurfSide.HEADS, possibleOutcomesHeads);
            possibleOutcomesEdge.put(MuenzwurfSide.TAILS, -1.0);
            possibleOutcomesEdge.put(MuenzwurfSide.HEADS, -1.0);
            possibleOutcomesEdge.put(MuenzwurfSide.EDGE, 1.0);
            possibleOutcomes.put(MuenzwurfSide.EDGE, possibleOutcomesEdge);
        } else {
            possibleOutcomesTails.put(MuenzwurfSide.TAILS, -1.0);
            possibleOutcomesTails.put(MuenzwurfSide.HEADS, 1.0);
            possibleOutcomesTails.put(MuenzwurfSide.EDGE, 1.0);
            possibleOutcomes.put(MuenzwurfSide.TAILS, possibleOutcomesTails);
            possibleOutcomesHeads.put(MuenzwurfSide.TAILS, 1.0);
            possibleOutcomesHeads.put(MuenzwurfSide.HEADS, -1.0);
            possibleOutcomesHeads.put(MuenzwurfSide.EDGE, 1.0);
            possibleOutcomes.put(MuenzwurfSide.HEADS, possibleOutcomesHeads);
            possibleOutcomesEdge.put(MuenzwurfSide.TAILS, 1.0);
            possibleOutcomesEdge.put(MuenzwurfSide.HEADS, 1.0);
            possibleOutcomesEdge.put(MuenzwurfSide.EDGE, -1.0);
            possibleOutcomes.put(MuenzwurfSide.EDGE, possibleOutcomesEdge);
        }
        return playerBuilder.changeName((String)playerData.get("playerName")).changePossibleOutcomes(possibleOutcomes).build();
    }

    private MuenzwurfStrategy getStrategy(Map<String, Object> playerData) {
        return (MuenzwurfStrategy)playerData.get("playerStrategy");
    }
}

