/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.othello.strategy.template;

import de.fhdw.gaming.othello.core.domain.OthelloBoard;
import de.fhdw.gaming.othello.core.domain.OthelloDirection;
import de.fhdw.gaming.othello.core.domain.OthelloField;
import de.fhdw.gaming.othello.core.domain.OthelloFieldState;
import de.fhdw.gaming.othello.core.domain.OthelloPlayer;
import de.fhdw.gaming.othello.core.domain.OthelloState;
import de.fhdw.gaming.othello.core.domain.OthelloStrategy;
import de.fhdw.gaming.othello.core.moves.OthelloMove;
import de.fhdw.gaming.othello.core.moves.factory.OthelloMoveFactory;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;

public final class OthelloMyStrategy
implements OthelloStrategy {
    private final OthelloMoveFactory moveFactory;

    OthelloMyStrategy(OthelloMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    public Optional<OthelloMove> computeNextMove(int gameId, OthelloPlayer player, OthelloState state) {
        OthelloBoard board = state.getBoard();
        Map emptyFields = board.getFieldsBeing(OthelloFieldState.EMPTY);
        boolean usingBlackTokens = player.isUsingBlackTokens();
        ArrayList activeFields = new ArrayList();
        emptyFields.values().stream().filter(field -> field.isActive(usingBlackTokens)).forEachOrdered(activeFields::add);
        if (activeFields.isEmpty()) {
            return Optional.of(this.moveFactory.createSkipMove(usingBlackTokens));
        }
        OthelloFieldState opponentState = usingBlackTokens ? OthelloFieldState.WHITE : OthelloFieldState.BLACK;
        for (OthelloField field2 : activeFields) {
            int opponentsBelow = (OthelloMyStrategy.isOpponent(field2, OthelloDirection.SOUTHEAST, opponentState) ? 1 : 0) + (OthelloMyStrategy.isOpponent(field2, OthelloDirection.SOUTH, opponentState) ? 1 : 0) + (OthelloMyStrategy.isOpponent(field2, OthelloDirection.SOUTHWEST, opponentState) ? 1 : 0);
            if (opponentsBelow < 2) continue;
            return Optional.of(this.moveFactory.createPlaceTokenMove(usingBlackTokens, field2.getPosition()));
        }
        return Optional.of(this.moveFactory.createPlaceTokenMove(usingBlackTokens, ((OthelloField)activeFields.get(0)).getPosition()));
    }

    public String toString() {
        return OthelloMyStrategy.class.getSimpleName();
    }

    private static boolean isOpponent(OthelloField field, OthelloDirection direction, OthelloFieldState desiredState) {
        return field.hasNeighbour(direction) && field.getNeighbour(direction).getState().equals((Object)desiredState);
    }
}

