/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.othello.gui.impl;

import de.fhdw.gaming.core.domain.Game;
import de.fhdw.gaming.gui.GuiObserver;
import de.fhdw.gaming.othello.core.domain.OthelloGame;
import de.fhdw.gaming.othello.gui.OthelloBoardEventProvider;
import de.fhdw.gaming.othello.gui.impl.OthelloBoardEventProviderImpl;
import de.fhdw.gaming.othello.gui.impl.OthelloBoardView;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javafx.scene.Node;

final class OthelloGuiObserverImpl
implements GuiObserver {
    private static final AtomicReference<WeakReference<OthelloGuiObserverImpl>> INSTANCE = new AtomicReference();
    private final Map<Integer, OthelloBoardView> boardViews;

    OthelloGuiObserverImpl() {
        INSTANCE.compareAndSet(null, new WeakReference<OthelloGuiObserverImpl>(this));
        this.boardViews = new LinkedHashMap<Integer, OthelloBoardView>();
    }

    static Optional<OthelloBoardEventProvider> getEventProvider(int gameId) {
        OthelloGuiObserverImpl instance = Optional.ofNullable(INSTANCE.get()).map(Reference::get).orElse(null);
        if (instance == null) {
            return Optional.empty();
        }
        OthelloBoardView boardView = instance.boardViews.get(gameId);
        return boardView == null ? Optional.empty() : Optional.of(new OthelloBoardEventProviderImpl(boardView));
    }

    public Optional<Node> gameCreated(Game<?, ?, ?, ?> game) {
        if (game instanceof OthelloGame) {
            OthelloBoardView boardView = new OthelloBoardView((OthelloGame)game);
            this.boardViews.put(game.getId(), boardView);
            return Optional.of(boardView.getNode());
        }
        return Optional.empty();
    }

    public void gamePaused(Game<?, ?, ?, ?> game) {
        OthelloBoardView boardView;
        if (game instanceof OthelloGame && (boardView = this.boardViews.get(game.getId())) != null) {
            boardView.gamePaused((OthelloGame)game);
        }
    }

    public void gameResumed(Game<?, ?, ?, ?> game) {
        OthelloBoardView boardView;
        if (game instanceof OthelloGame && (boardView = this.boardViews.get(game.getId())) != null) {
            boardView.gameResumed((OthelloGame)game);
        }
    }

    public void gameDestroyed(Game<?, ?, ?, ?> game) {
        OthelloBoardView boardView;
        if (game instanceof OthelloGame && (boardView = this.boardViews.remove(game.getId())) != null) {
            boardView.destroy((OthelloGame)game);
        }
    }
}

