/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.othello.gui.impl;

import de.fhdw.gaming.othello.core.domain.OthelloBoard;
import de.fhdw.gaming.othello.core.domain.OthelloField;
import de.fhdw.gaming.othello.core.domain.OthelloFieldState;
import de.fhdw.gaming.othello.core.domain.OthelloPlayer;
import de.fhdw.gaming.othello.core.domain.OthelloPosition;
import de.fhdw.gaming.othello.core.domain.OthelloState;
import de.fhdw.gaming.othello.gui.OthelloBoardEventProvider;
import de.fhdw.gaming.othello.gui.event.OthelloBoardEvent;
import de.fhdw.gaming.othello.gui.event.OthelloMakeMoveBoardEvent;
import de.fhdw.gaming.othello.gui.event.OthelloSkipMoveBoardEvent;
import de.fhdw.gaming.othello.gui.impl.OthelloBoardView;
import de.fhdw.gaming.othello.gui.impl.OthelloFieldView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Platform;
import javafx.scene.Cursor;
import javafx.scene.input.MouseButton;

final class OthelloBoardEventProviderImpl
implements OthelloBoardEventProvider {
    private final OthelloBoardView boardView;

    OthelloBoardEventProviderImpl(OthelloBoardView boardView) {
        this.boardView = boardView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OthelloBoardEvent waitForEvent(OthelloPlayer player, OthelloState state) {
        Runnable cleanUp;
        Object fieldViews;
        LinkedHashMap<OthelloPosition, OthelloFieldView> activeFieldViews = new LinkedHashMap<OthelloPosition, OthelloFieldView>();
        for (Map.Entry entry : state.getBoard().getFieldsBeing(OthelloFieldState.EMPTY).entrySet()) {
            OthelloField field = (OthelloField)entry.getValue();
            if (!field.isActive(player.isUsingBlackTokens())) continue;
            activeFieldViews.put((OthelloPosition)entry.getKey(), this.boardView.getFieldView((OthelloPosition)entry.getKey()).orElseThrow());
        }
        AtomicReference<OthelloBoardEvent> event = new AtomicReference<OthelloBoardEvent>();
        if (activeFieldViews.isEmpty()) {
            fieldViews = this.setupInactiveFields(state.getBoard(), event);
            cleanUp = () -> this.cleanUpFields((Collection<? extends OthelloFieldView>)fieldViews);
        } else {
            this.setupActiveFields(activeFieldViews, event);
            cleanUp = () -> this.cleanUpFields(activeFieldViews.values());
        }
        try {
            this.boardView.getUserInputSemaphore().acquire();
            fieldViews = event.get();
            return fieldViews;
        }
        catch (InterruptedException e) {
            OthelloBoardEvent othelloBoardEvent = null;
            return othelloBoardEvent;
        }
        finally {
            Platform.runLater((Runnable)cleanUp);
        }
    }

    private void setupActiveFields(Map<OthelloPosition, OthelloFieldView> activeFieldViews, AtomicReference<OthelloBoardEvent> event) {
        for (Map.Entry<OthelloPosition, OthelloFieldView> entry : activeFieldViews.entrySet()) {
            OthelloPosition position = entry.getKey();
            OthelloFieldView fieldView = entry.getValue();
            Platform.runLater(() -> {
                fieldView.setCursor(Cursor.CROSSHAIR);
                fieldView.setHighlighted(true);
                fieldView.setOnMouseClicked(mouseEvent -> {
                    if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                        event.set(new OthelloMakeMoveBoardEvent(position));
                        this.boardView.getUserInputSemaphore().release();
                    }
                });
            });
        }
    }

    private List<OthelloFieldView> setupInactiveFields(OthelloBoard board, AtomicReference<OthelloBoardEvent> event) {
        ArrayList fields = new ArrayList();
        board.getFields().forEach(fields::addAll);
        ArrayList<OthelloFieldView> fieldViews = new ArrayList<OthelloFieldView>();
        for (OthelloField field : fields) {
            OthelloFieldView fieldView = this.boardView.getFieldView(field.getPosition()).orElseThrow();
            fieldViews.add(fieldView);
            Platform.runLater(() -> {
                fieldView.setCursor(Cursor.CLOSED_HAND);
                fieldView.setOnMouseClicked(mouseEvent -> {
                    event.set(new OthelloSkipMoveBoardEvent());
                    this.boardView.getUserInputSemaphore().release();
                });
            });
        }
        return fieldViews;
    }

    private void cleanUpFields(Collection<? extends OthelloFieldView> fieldViews) {
        for (OthelloFieldView othelloFieldView : fieldViews) {
            othelloFieldView.setCursor(Cursor.DEFAULT);
            othelloFieldView.setHighlighted(false);
            othelloFieldView.setOnMouseClicked(null);
        }
    }

    @Override
    public void cancelWaiting() {
        this.boardView.getUserInputSemaphore().release();
    }
}

