/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.othello.strategy.examples.maxFlips;

import de.fhdw.gaming.othello.core.domain.OthelloDirection;
import de.fhdw.gaming.othello.core.domain.OthelloField;
import de.fhdw.gaming.othello.core.domain.OthelloFieldState;
import de.fhdw.gaming.othello.core.domain.OthelloPlayer;
import de.fhdw.gaming.othello.core.domain.OthelloState;
import de.fhdw.gaming.othello.core.domain.OthelloStrategy;
import de.fhdw.gaming.othello.core.moves.OthelloMove;
import de.fhdw.gaming.othello.core.moves.factory.OthelloMoveFactory;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;

public final class OthelloMaxFlipsMoveStrategy
implements OthelloStrategy {
    private static final Random RANDOM = new Random();
    private final OthelloMoveFactory moveFactory;

    OthelloMaxFlipsMoveStrategy(OthelloMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    public Optional<OthelloMove> computeNextMove(int gameId, OthelloPlayer player, OthelloState state, long maxComputationTimePerMove) {
        LinkedHashMap<OthelloField, Integer> tokensFlipped = new LinkedHashMap<OthelloField, Integer>();
        boolean usingBlackTokens = player.isUsingBlackTokens();
        OthelloFieldState fieldState = usingBlackTokens ? OthelloFieldState.BLACK : OthelloFieldState.WHITE;
        for (OthelloField field : state.getBoard().getFieldsBeing(OthelloFieldState.EMPTY).values()) {
            if (!field.isActive(usingBlackTokens)) continue;
            tokensFlipped.put(field, this.getNumberOfTokensFlipped(field, fieldState));
        }
        List bestFields = tokensFlipped.entrySet().stream().sorted((item1, item2) -> ((Integer)item2.getValue()).compareTo((Integer)item1.getValue())).map(Map.Entry::getKey).collect(Collectors.toList());
        if (bestFields.isEmpty()) {
            return Optional.of(this.moveFactory.createSkipMove(usingBlackTokens));
        }
        int index = RANDOM.nextInt(bestFields.size());
        return Optional.of(this.moveFactory.createPlaceTokenMove(usingBlackTokens, ((OthelloField)bestFields.get(index)).getPosition()));
    }

    public String toString() {
        return OthelloMaxFlipsMoveStrategy.class.getSimpleName();
    }

    private int getNumberOfTokensFlipped(OthelloField field, OthelloFieldState delimiterState) {
        int tokensFlipped = 0;
        for (OthelloDirection direction : OthelloDirection.values()) {
            tokensFlipped += field.getLineOfTokens(direction, delimiterState).size();
        }
        return tokensFlipped;
    }
}

