/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.othello.gui.impl;

import de.fhdw.gaming.core.domain.Game;
import de.fhdw.gaming.core.domain.Move;
import de.fhdw.gaming.core.domain.Observer;
import de.fhdw.gaming.core.domain.Player;
import de.fhdw.gaming.core.domain.PlayerState;
import de.fhdw.gaming.core.domain.State;
import de.fhdw.gaming.othello.core.domain.OthelloBoard;
import de.fhdw.gaming.othello.core.domain.OthelloFieldState;
import de.fhdw.gaming.othello.core.domain.OthelloObserver;
import de.fhdw.gaming.othello.core.domain.OthelloPlayer;
import de.fhdw.gaming.othello.core.domain.OthelloPosition;
import de.fhdw.gaming.othello.core.domain.OthelloState;
import de.fhdw.gaming.othello.core.domain.OthelloStrategy;
import de.fhdw.gaming.othello.core.moves.OthelloMove;
import de.fhdw.gaming.othello.gui.impl.OthelloFieldView;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.stage.Screen;
import javafx.util.Duration;

final class OthelloBoardView
implements OthelloObserver {
    private static final double INITIAL_DELAY = 0.5;
    private static final double STATE_PANE_MARGIN = 40.0;
    private static final Pattern STRATEGY_NAME_PATTERN = Pattern.compile("^(Othello)?(.*?)(Strategy)?$");
    private final double pixelsToPointsFactor;
    private final Map<OthelloPosition, OthelloFieldView> controls;
    private final HBox rootPane;
    private final VBox boardPane;
    private final GridPane fieldPane;
    private Label blackTokens;
    private Label whiteTokens;
    private Label gameStateDescription;
    private Optional<Timeline> gameStateDescriptionAnimation;
    private final AtomicInteger delay;
    private final SimpleDoubleProperty fieldControlSize;
    private final SimpleDoubleProperty margin;
    private final SimpleObjectProperty<Insets> gridPadding;
    private final SimpleDoubleProperty fontSizeInPixels;
    private final SimpleObjectProperty<Font> borderLabelFont;
    private final SimpleObjectProperty<Font> labelTextFont;
    private final SimpleObjectProperty<Font> labelValueFont;
    private final SimpleObjectProperty<Font> gameResultFont;
    private HBox topEdge;
    private VBox leftEdge;
    private VBox rightEdge;
    private HBox bottomEdge;
    private Optional<OthelloState> lastGameState;
    private final Semaphore semaphore = new Semaphore(0);

    OthelloBoardView(Game<OthelloPlayer, OthelloState, OthelloMove, OthelloStrategy> game) {
        this.pixelsToPointsFactor = 72.0 / Screen.getPrimary().getDpi();
        this.borderLabelFont = new SimpleObjectProperty((Object)Font.getDefault());
        this.labelTextFont = new SimpleObjectProperty((Object)Font.getDefault());
        this.labelValueFont = new SimpleObjectProperty((Object)Font.getDefault());
        this.gameResultFont = new SimpleObjectProperty((Object)Font.getDefault());
        this.fieldControlSize = new SimpleDoubleProperty(0.0);
        this.margin = new SimpleDoubleProperty(0.0);
        this.gridPadding = new SimpleObjectProperty((Object)Insets.EMPTY);
        this.fontSizeInPixels = new SimpleDoubleProperty(0.0);
        this.controls = new LinkedHashMap<OthelloPosition, OthelloFieldView>();
        this.fieldPane = new GridPane();
        this.boardPane = this.createFieldWithBorderPane();
        GridPane statePane = this.createStatePane(game);
        this.rootPane = new HBox();
        this.rootPane.getChildren().addAll((Object[])new Node[]{this.boardPane, statePane});
        HBox.setHgrow((Node)this.boardPane, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)statePane, (Priority)Priority.ALWAYS);
        HBox.setMargin((Node)statePane, (Insets)new Insets(40.0));
        this.delay = new AtomicInteger(500);
        this.lastGameState = Optional.empty();
        game.addObserver((Observer)this);
        this.gameStateDescriptionAnimation = Optional.empty();
    }

    private VBox createFieldWithBorderPane() {
        Background background = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.SANDYBROWN, CornerRadii.EMPTY, Insets.EMPTY)});
        HBox topLeftCorner = new HBox();
        topLeftCorner.setBackground(background);
        topLeftCorner.minHeightProperty().bind((ObservableValue)this.fieldControlSize.multiply(0.5));
        topLeftCorner.minWidthProperty().bind((ObservableValue)this.fieldControlSize.multiply(0.5));
        this.topEdge = new HBox();
        this.topEdge.setBackground(background);
        this.topEdge.minHeightProperty().bind((ObservableValue)this.fieldControlSize.multiply(0.5));
        this.topEdge.setAlignment(Pos.CENTER);
        HBox topRightCorner = new HBox();
        topRightCorner.setBackground(background);
        topRightCorner.minHeightProperty().bind((ObservableValue)this.fieldControlSize.multiply(0.5));
        topRightCorner.minWidthProperty().bind((ObservableValue)this.fieldControlSize.multiply(0.5));
        HBox.setHgrow((Node)topLeftCorner, (Priority)Priority.NEVER);
        HBox.setHgrow((Node)this.topEdge, (Priority)Priority.NEVER);
        HBox.setHgrow((Node)topRightCorner, (Priority)Priority.NEVER);
        this.leftEdge = new VBox();
        this.leftEdge.setBackground(background);
        this.leftEdge.minWidthProperty().bind((ObservableValue)this.fieldControlSize.multiply(0.5));
        this.leftEdge.setAlignment(Pos.CENTER);
        this.rightEdge = new VBox();
        this.rightEdge.setBackground(background);
        this.rightEdge.minWidthProperty().bind((ObservableValue)this.fieldControlSize.multiply(0.5));
        this.rightEdge.setAlignment(Pos.CENTER);
        HBox.setHgrow((Node)this.leftEdge, (Priority)Priority.NEVER);
        HBox.setHgrow((Node)this.fieldPane, (Priority)Priority.NEVER);
        HBox.setHgrow((Node)this.rightEdge, (Priority)Priority.NEVER);
        HBox bottomLeftCorner = new HBox();
        bottomLeftCorner.setBackground(background);
        bottomLeftCorner.minHeightProperty().bind((ObservableValue)this.fieldControlSize.multiply(0.5));
        bottomLeftCorner.minWidthProperty().bind((ObservableValue)this.fieldControlSize.multiply(0.5));
        this.bottomEdge = new HBox();
        this.bottomEdge.setBackground(background);
        this.bottomEdge.minHeightProperty().bind((ObservableValue)this.fieldControlSize.multiply(0.5));
        this.bottomEdge.setAlignment(Pos.CENTER);
        HBox bottomRightCorner = new HBox();
        bottomRightCorner.setBackground(background);
        bottomRightCorner.minHeightProperty().bind((ObservableValue)this.fieldControlSize.multiply(0.5));
        bottomRightCorner.minWidthProperty().bind((ObservableValue)this.fieldControlSize.multiply(0.5));
        HBox.setHgrow((Node)bottomLeftCorner, (Priority)Priority.NEVER);
        HBox.setHgrow((Node)this.bottomEdge, (Priority)Priority.NEVER);
        HBox.setHgrow((Node)bottomRightCorner, (Priority)Priority.NEVER);
        HBox top = new HBox();
        top.getChildren().addAll((Object[])new Node[]{topLeftCorner, this.topEdge, topRightCorner});
        HBox centre = new HBox();
        centre.getChildren().addAll((Object[])new Node[]{this.leftEdge, this.fieldPane, this.rightEdge});
        HBox bottom = new HBox();
        bottom.getChildren().addAll((Object[])new Node[]{bottomLeftCorner, this.bottomEdge, bottomRightCorner});
        VBox.setVgrow((Node)top, (Priority)Priority.NEVER);
        VBox.setVgrow((Node)centre, (Priority)Priority.NEVER);
        VBox.setVgrow((Node)bottom, (Priority)Priority.NEVER);
        VBox vbox = new VBox();
        vbox.getChildren().addAll((Object[])new Node[]{top, centre, bottom});
        return vbox;
    }

    private GridPane createStatePane(Game<OthelloPlayer, OthelloState, OthelloMove, OthelloStrategy> game) {
        GridPane blackPlayerPane = this.createPlayerPane(game, ((OthelloState)game.getState()).getBlackPlayer());
        GridPane whitePlayerPane = this.createPlayerPane(game, ((OthelloState)game.getState()).getWhitePlayer());
        this.gameStateDescription = new Label();
        this.gameStateDescription.fontProperty().bind(this.gameResultFont);
        this.gameStateDescription.setTextFill((Paint)Color.RED);
        Label delayLabel = new Label("Delay in seconds: ");
        Slider delaySlider = new Slider(0.0, 5.0, 0.5);
        delaySlider.setMajorTickUnit(0.5);
        delaySlider.setMinorTickCount(4);
        delaySlider.setBlockIncrement(0.5);
        delaySlider.setShowTickMarks(true);
        delaySlider.setShowTickLabels(true);
        delaySlider.snapToTicksProperty().set(true);
        delaySlider.valueProperty().addListener((observable, oldValue, newValue) -> this.delay.set((int)(newValue.doubleValue() * 1000.0)));
        HBox delayBox = new HBox(new Node[]{delayLabel, delaySlider});
        HBox.setHgrow((Node)delayLabel, (Priority)Priority.NEVER);
        HBox.setHgrow((Node)delaySlider, (Priority)Priority.ALWAYS);
        GridPane gridPane = new GridPane();
        gridPane.vgapProperty().bind((ObservableValue)this.margin.multiply(2.0));
        gridPane.addRow(0, new Node[]{blackPlayerPane});
        GridPane.setHalignment((Node)blackPlayerPane, (HPos)HPos.CENTER);
        GridPane.setHgrow((Node)blackPlayerPane, (Priority)Priority.ALWAYS);
        GridPane.setVgrow((Node)blackPlayerPane, (Priority)Priority.NEVER);
        gridPane.addRow(1, new Node[]{whitePlayerPane});
        GridPane.setHalignment((Node)whitePlayerPane, (HPos)HPos.CENTER);
        GridPane.setHgrow((Node)whitePlayerPane, (Priority)Priority.ALWAYS);
        GridPane.setVgrow((Node)whitePlayerPane, (Priority)Priority.NEVER);
        gridPane.addRow(2, new Node[]{this.gameStateDescription});
        GridPane.setHalignment((Node)this.gameStateDescription, (HPos)HPos.CENTER);
        GridPane.setHgrow((Node)this.gameStateDescription, (Priority)Priority.ALWAYS);
        GridPane.setVgrow((Node)this.gameStateDescription, (Priority)Priority.NEVER);
        gridPane.addRow(3, new Node[]{delayBox});
        GridPane.setHalignment((Node)delayBox, (HPos)HPos.CENTER);
        GridPane.setHgrow((Node)delayBox, (Priority)Priority.ALWAYS);
        GridPane.setVgrow((Node)delayBox, (Priority)Priority.NEVER);
        return gridPane;
    }

    HBox getNode() {
        return this.rootPane;
    }

    Semaphore getUserInputSemaphore() {
        return this.semaphore;
    }

    Optional<OthelloFieldView> getFieldView(OthelloPosition position) {
        return Optional.ofNullable(this.controls.get(position));
    }

    private void setGameState(String text) {
        this.gameStateDescriptionAnimation.ifPresent(Animation::stop);
        this.gameStateDescription.setText(text);
        if (!text.isEmpty()) {
            this.gameStateDescriptionAnimation = Optional.of(new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)0.5), evt -> this.gameStateDescription.setVisible(false), new KeyValue[0]), new KeyFrame(Duration.seconds((double)1.0), evt -> this.gameStateDescription.setVisible(true), new KeyValue[0])}));
            this.gameStateDescriptionAnimation.get().setCycleCount(-1);
            this.gameStateDescriptionAnimation.get().play();
        }
    }

    void gamePaused(Game<OthelloPlayer, OthelloState, OthelloMove, OthelloStrategy> game) {
        Platform.runLater(() -> this.setGameState("P A U S E D"));
    }

    void gameResumed(Game<OthelloPlayer, OthelloState, OthelloMove, OthelloStrategy> game) {
        Platform.runLater(() -> this.setGameState(""));
    }

    public void started(Game<?, ?, ?, ?> game, State<?, ?> state) throws InterruptedException {
        Platform.runLater(() -> {
            this.lastGameState = Optional.of((OthelloState)state);
            OthelloBoard board = this.lastGameState.get().getBoard();
            int numRowsAndColumns = board.getSize();
            this.addLabelsToEdge(numRowsAndColumns);
            this.boardPane.widthProperty().addListener((observable, oldValue, newValue) -> {
                double size = Math.min(newValue.doubleValue(), this.boardPane.getHeight());
                this.setBorderAndFieldSize(numRowsAndColumns, size);
            });
            this.boardPane.heightProperty().addListener((observable, oldValue, newValue) -> {
                double size = Math.min(newValue.doubleValue(), this.boardPane.getWidth());
                this.setBorderAndFieldSize(numRowsAndColumns, size);
            });
            this.fieldPane.widthProperty().addListener((observable, oldValue, newValue) -> {
                double size = Math.min(newValue.doubleValue(), this.fieldPane.getHeight());
                this.fieldControlSize.set(size / (double)numRowsAndColumns);
            });
            this.fieldPane.heightProperty().addListener((observable, oldValue, newValue) -> {
                double size = Math.min(newValue.doubleValue(), this.fieldPane.getWidth());
                this.fieldControlSize.set(size / (double)numRowsAndColumns);
            });
            IntStream.range(0, numRowsAndColumns).forEachOrdered(row -> IntStream.range(0, numRowsAndColumns).forEachOrdered(column -> {
                OthelloPosition position = OthelloPosition.of((int)row, (int)column);
                OthelloFieldState fieldState = board.getFieldAt(position).getState();
                OthelloFieldView fieldControl = new OthelloFieldView(fieldState);
                this.fieldPane.add((Node)fieldControl, column, row);
                this.controls.put(position, fieldControl);
                fieldControl.prefWidthProperty().bind((ObservableValue)this.fieldControlSize);
                fieldControl.prefHeightProperty().bind((ObservableValue)this.fieldControlSize);
            }));
        });
        this.delayNextMove();
    }

    private void addLabelsToEdge(int numRowsAndColumns) {
        for (int i = 0; i < numRowsAndColumns; i = (int)((char)(i + 1))) {
            Label leftLabel = new Label(String.valueOf((char)(i + 49)));
            leftLabel.fontProperty().bind(this.borderLabelFont);
            leftLabel.setMaxHeight(Double.MAX_VALUE);
            leftLabel.setAlignment(Pos.CENTER);
            this.leftEdge.getChildren().add((Object)leftLabel);
            VBox.setVgrow((Node)leftLabel, (Priority)Priority.ALWAYS);
            Label rightLabel = new Label(String.valueOf((char)(i + 49)));
            rightLabel.fontProperty().bind(this.borderLabelFont);
            rightLabel.setMaxHeight(Double.MAX_VALUE);
            rightLabel.setAlignment(Pos.CENTER);
            this.rightEdge.getChildren().add((Object)rightLabel);
            VBox.setVgrow((Node)rightLabel, (Priority)Priority.ALWAYS);
            Label topLabel = new Label(String.valueOf((char)(i + 65)));
            topLabel.fontProperty().bind(this.borderLabelFont);
            topLabel.setMaxWidth(Double.MAX_VALUE);
            topLabel.setAlignment(Pos.CENTER);
            this.topEdge.getChildren().add((Object)topLabel);
            HBox.setHgrow((Node)topLabel, (Priority)Priority.ALWAYS);
            Label bottomLabel = new Label(String.valueOf((char)(i + 65)));
            bottomLabel.fontProperty().bind(this.borderLabelFont);
            bottomLabel.setMaxWidth(Double.MAX_VALUE);
            bottomLabel.setAlignment(Pos.CENTER);
            this.bottomEdge.getChildren().add((Object)bottomLabel);
            HBox.setHgrow((Node)bottomLabel, (Priority)Priority.ALWAYS);
        }
    }

    private void setBorderAndFieldSize(int numRowsAndColumns, double boardSizeInPixels) {
        double boardSizeWithoutBorders = boardSizeInPixels * (double)numRowsAndColumns / (double)(numRowsAndColumns + 1);
        this.fieldPane.setPrefSize(boardSizeWithoutBorders, boardSizeWithoutBorders);
        this.topEdge.setPrefWidth(boardSizeWithoutBorders);
        this.leftEdge.setPrefHeight(boardSizeWithoutBorders);
        this.rightEdge.setPrefHeight(boardSizeWithoutBorders);
        this.bottomEdge.setPrefWidth(boardSizeWithoutBorders);
        this.fontSizeInPixels.set(this.fieldControlSize.get() * 0.5);
        double fontSize = this.fontSizeInPixels.get() * this.pixelsToPointsFactor;
        Font fontRegular = Font.font(null, (FontWeight)FontWeight.NORMAL, (FontPosture)FontPosture.REGULAR, (double)fontSize);
        Font fontBold = Font.font(null, (FontWeight)FontWeight.BOLD, (FontPosture)FontPosture.REGULAR, (double)fontSize);
        this.borderLabelFont.set((Object)fontRegular);
        this.labelTextFont.set((Object)fontBold);
        this.labelValueFont.set((Object)fontRegular);
        this.gameResultFont.set((Object)fontBold);
        this.margin.set(this.fontSizeInPixels.get() * 0.25);
        this.gridPadding.set((Object)new Insets(this.margin.get()));
    }

    public void nextPlayersComputed(Game<?, ?, ?, ?> game, State<?, ?> state, Set<? extends Player<?>> players) {
    }

    public void illegalPlayerRejected(Game<?, ?, ?, ?> game, State<?, ?> state, Player<?> player) {
    }

    public void legalMoveApplied(Game<?, ?, ?, ?> game, State<?, ?> state, Player<?> player, Move<?, ?> move) throws InterruptedException {
        Platform.runLater(() -> {
            OthelloState othelloState = (OthelloState)state;
            this.updateFields(othelloState, OthelloFieldState.BLACK, this.blackTokens);
            this.updateFields(othelloState, OthelloFieldState.WHITE, this.whiteTokens);
            this.lastGameState = Optional.of(othelloState);
        });
        this.delayNextMove();
    }

    private void updateFields(OthelloState othelloState, OthelloFieldState fieldState, Label label) {
        LinkedHashSet currentFieldsInDesiredState = new LinkedHashSet(othelloState.getBoard().getFieldsBeing(fieldState).keySet());
        label.setText(Integer.toString(currentFieldsInDesiredState.size()));
        currentFieldsInDesiredState.removeAll(this.lastGameState.orElseThrow().getBoard().getFieldsBeing(fieldState).keySet());
        currentFieldsInDesiredState.forEach(position -> this.controls.get(position).setFieldState(fieldState));
    }

    public void illegalMoveRejected(Game<?, ?, ?, ?> game, State<?, ?> state, Player<?> player, Optional<Move<?, ?>> move, String reason) {
    }

    public void overdueMoveRejected(Game<?, ?, ?, ?> game, State<?, ?> state, Player<?> player, Optional<Move<?, ?>> chosenMove) {
    }

    public void playerResigned(Game<?, ?, ?, ?> game, State<?, ?> state, Player<?> player) {
    }

    public void playerOvertaken(Game<?, ?, ?, ?> game, State<?, ?> state, Player<?> overtakenPlayer, Player<?> overtakingPlayer) {
    }

    public void finished(Game<?, ?, ?, ?> game, State<?, ?> state) {
        Platform.runLater(() -> {
            OthelloState othelloState = (OthelloState)state;
            if (othelloState.getBlackPlayer().getState().equals((Object)PlayerState.WON)) {
                this.setGameState("BLACK WINS!");
            } else if (othelloState.getWhitePlayer().getState().equals((Object)PlayerState.WON)) {
                this.setGameState("WHITE WINS!");
            } else if (othelloState.getBlackPlayer().getState().equals((Object)PlayerState.DRAW)) {
                this.setGameState("DRAW GAME!");
            }
        });
    }

    public void destroy(Game<OthelloPlayer, OthelloState, OthelloMove, OthelloStrategy> game) {
        this.gameStateDescriptionAnimation.ifPresent(Animation::stop);
        this.semaphore.release();
        game.removeObserver((Observer)this);
    }

    private void delayNextMove() throws InterruptedException {
        Thread.sleep(this.delay.get());
    }

    private GridPane createPlayerPane(Game<OthelloPlayer, OthelloState, OthelloMove, OthelloStrategy> game, OthelloPlayer player) {
        Label nameLabel = new Label("Name:");
        nameLabel.fontProperty().bind(this.labelTextFont);
        Label nameText = new Label(player.getName());
        nameText.fontProperty().bind(this.labelValueFont);
        Label colourLabel = new Label("Colour:");
        colourLabel.fontProperty().bind(this.labelTextFont);
        Label colourText = new Label();
        colourText.fontProperty().bind(this.labelValueFont);
        if (player.isUsingBlackTokens()) {
            circle = new Circle();
            circle.radiusProperty().bind((ObservableValue)this.fontSizeInPixels.multiply(0.25));
            circle.setFill((Paint)Color.BLACK);
            circle.setStroke((Paint)Color.BLACK);
            colourText.setGraphic((Node)circle);
        } else {
            circle = new Circle();
            circle.radiusProperty().bind((ObservableValue)this.fontSizeInPixels.multiply(0.25));
            circle.setFill((Paint)Color.WHITE);
            circle.setStroke((Paint)Color.BLACK);
            colourText.setGraphic((Node)circle);
        }
        Label strategyLabel = new Label("Strategy:");
        strategyLabel.fontProperty().bind(this.labelTextFont);
        String rawName = ((OthelloStrategy)game.getStrategies().get(player.getName())).toString();
        Matcher nameMatcher = STRATEGY_NAME_PATTERN.matcher(rawName);
        Label strategyText = nameMatcher.matches() ? new Label(nameMatcher.group(2)) : new Label(rawName);
        strategyText.fontProperty().bind(this.labelValueFont);
        Label tokensLabel = new Label("Tokens:");
        tokensLabel.fontProperty().bind(this.labelTextFont);
        Label tokensText = new Label("0");
        tokensText.fontProperty().bind(this.labelValueFont);
        if (player.isUsingBlackTokens()) {
            this.blackTokens = tokensText;
        } else {
            this.whiteTokens = tokensText;
        }
        GridPane gridPane = new GridPane();
        ColumnConstraints labelColumnConstraints = new ColumnConstraints();
        labelColumnConstraints.setHalignment(HPos.RIGHT);
        labelColumnConstraints.setHgrow(Priority.NEVER);
        ColumnConstraints textColumnConstraints = new ColumnConstraints();
        textColumnConstraints.setHalignment(HPos.LEFT);
        textColumnConstraints.setHgrow(Priority.ALWAYS);
        textColumnConstraints.setMaxWidth(Double.MAX_VALUE);
        gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{labelColumnConstraints, textColumnConstraints});
        RowConstraints rowConstraints = new RowConstraints();
        rowConstraints.setValignment(VPos.TOP);
        gridPane.getRowConstraints().addAll((Object[])new RowConstraints[]{rowConstraints, rowConstraints, rowConstraints, rowConstraints});
        gridPane.addRow(0, new Node[]{nameLabel, nameText});
        gridPane.addRow(1, new Node[]{colourLabel, colourText});
        gridPane.addRow(2, new Node[]{strategyLabel, strategyText});
        gridPane.addRow(3, new Node[]{tokensLabel, tokensText});
        gridPane.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Color.BLACK, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, BorderStroke.THICK)}));
        gridPane.hgapProperty().bind((ObservableValue)this.margin.multiply(2.0));
        gridPane.paddingProperty().bind(this.gridPadding);
        return gridPane;
    }
}

