/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.hfp416.spaces.template;

import de.fhdw.hfp416.spaces.entry.Entry;
import de.fhdw.hfp416.spaces.entry.ObjectEntry;
import de.fhdw.hfp416.spaces.entry.ReferenceEntry;
import de.fhdw.hfp416.spaces.entry.visitor.EntryReturnDefaultVisitor;
import de.fhdw.hfp416.spaces.template.Template;
import java.util.HashMap;
import java.util.Map;

public class ObjectTemplate
extends Template {
    private final Map<String, Template> attributes;

    @Override
    protected boolean matchAttributes(Entry entry, final Map<Template, Entry> alreadyCheckedEntries) {
        return entry.accept(new EntryReturnDefaultVisitor<Boolean>(){

            @Override
            public Boolean handle(ObjectEntry entry) {
                return ObjectTemplate.this.matchObjectEntry(entry, alreadyCheckedEntries);
            }

            @Override
            public Boolean handle(ReferenceEntry entry) {
                return ObjectTemplate.this.matchObjectEntry(entry.getReference(), alreadyCheckedEntries);
            }

            @Override
            protected Boolean defaultHandle(Entry entry) {
                return false;
            }
        });
    }

    public ObjectTemplate(String name, String namespace, Map<String, Template> attributes) {
        super(name, namespace);
        this.attributes = attributes;
    }

    public ObjectTemplate(String name, String namespace) {
        this(name, namespace, new HashMap<String, Template>());
    }

    public void addTemplate(String attributeName, Template template) {
        this.getAttributes().put(attributeName, template);
    }

    public Map<String, Template> getAttributes() {
        return this.attributes;
    }

    protected boolean matchObjectEntry(ObjectEntry entry, Map<Template, Entry> alreadyCheckedEntries) {
        if (alreadyCheckedEntries.containsKey(this) && alreadyCheckedEntries.get(this) == entry) {
            return true;
        }
        alreadyCheckedEntries.put(this, entry);
        for (String current : this.getAttributes().keySet()) {
            boolean foundFittingAttributeForThis = this.checkOneEntryInEntry(entry, current, this.getAttributes().get(current), alreadyCheckedEntries);
            if (foundFittingAttributeForThis) continue;
            return false;
        }
        return true;
    }

    private boolean checkOneEntryInEntry(ObjectEntry entry, String attributeName, Template template, Map<Template, Entry> alreadyCheckedEntries) {
        if (entry.getAttributes().containsKey(attributeName)) {
            Entry currentAttribute = entry.getAttributes().get(attributeName);
            return template.matchInternal(currentAttribute, alreadyCheckedEntries);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ObjectTemplate other = (ObjectTemplate)obj;
        return !(this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes));
    }

    public String toString() {
        return "ObjectTemplate [attributes=" + this.attributes + "]";
    }
}

