/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.hfp416.spaces.template;

import de.fhdw.hfp416.spaces.entry.Entry;
import de.fhdw.hfp416.spaces.entry.primitiveentry.ByteEntry;
import de.fhdw.hfp416.spaces.entry.primitiveentry.DoubleEntry;
import de.fhdw.hfp416.spaces.entry.primitiveentry.FloatEntry;
import de.fhdw.hfp416.spaces.entry.primitiveentry.IntegerEntry;
import de.fhdw.hfp416.spaces.entry.primitiveentry.LongEntry;
import de.fhdw.hfp416.spaces.entry.primitiveentry.ShortEntry;
import de.fhdw.hfp416.spaces.entry.visitor.EntryReturnDefaultVisitor;
import de.fhdw.hfp416.spaces.template.PrimitiveTemplate;
import de.fhdw.hfp416.spaces.template.Template;
import de.fhdw.hfp416.spaces.template.interval.Exclusive;
import de.fhdw.hfp416.spaces.template.interval.Inclusive;
import de.fhdw.hfp416.spaces.template.interval.IntervalAffiliationReturnVisitor;
import de.fhdw.hfp416.spaces.template.interval.IntervalBound;
import de.fhdw.hfp416.spaces.template.interval.NumberIntervalBound;
import java.util.Map;

public class NumberInterval<N extends Number>
extends PrimitiveTemplate {
    private final IntervalBound<N> lowerBound;
    private final IntervalBound<N> upperBound;
    private final Class<N> type;
    private static final String BRACKET_ROUND_OPEN = "(";
    private static final String BRACKET_ROUND_CLOSE = ")";
    private static final String BRACKET_EDGE_OPEN = "[";
    private static final String BRACKET_EDGE_CLOSE = "]";

    public NumberInterval(N lowerBound, N upperBound, Class<N> type) {
        this(new NumberIntervalBound<N>(lowerBound), new NumberIntervalBound<N>(upperBound), type);
    }

    public NumberInterval(IntervalBound<N> lowerBound, IntervalBound<N> upperBound, Class<N> type) {
        super(type.getSimpleName(), type.getPackage().getName());
        if (!lowerBound.isSmallerOrEqual(upperBound)) {
            throw new IllegalArgumentException("negative interval not allowed!");
        }
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.type = type;
    }

    public boolean isBetween(N value) {
        return this.getLowerBound().checkAsLowerBound(value) && this.getUpperBound().checkAsUpperBound(value);
    }

    public IntervalBound<N> getLowerBound() {
        return this.lowerBound;
    }

    public IntervalBound<N> getUpperBound() {
        return this.upperBound;
    }

    public Class<N> getType() {
        return this.type;
    }

    @Override
    protected boolean matchAttributes(Entry entry, Map<Template, Entry> alreadyCheckedEntries) {
        return entry.accept(new EntryReturnDefaultVisitor<Boolean>(){

            @Override
            public Boolean handle(ByteEntry entry) {
                if (!entry.getValue().getClass().equals(NumberInterval.this.type)) {
                    return false;
                }
                return NumberInterval.this.getLowerBound().checkAsLowerBound(entry.getValue()) && NumberInterval.this.getUpperBound().checkAsUpperBound(entry.getValue());
            }

            @Override
            public Boolean handle(DoubleEntry entry) {
                if (!entry.getValue().getClass().equals(NumberInterval.this.type)) {
                    return false;
                }
                return NumberInterval.this.getLowerBound().checkAsLowerBound(entry.getValue()) && NumberInterval.this.getUpperBound().checkAsUpperBound(entry.getValue());
            }

            @Override
            public Boolean handle(FloatEntry entry) {
                if (!entry.getValue().getClass().equals(NumberInterval.this.type)) {
                    return false;
                }
                return NumberInterval.this.getLowerBound().checkAsLowerBound(entry.getValue()) && NumberInterval.this.getUpperBound().checkAsUpperBound(entry.getValue());
            }

            @Override
            public Boolean handle(IntegerEntry entry) {
                if (!entry.getValue().getClass().equals(NumberInterval.this.type)) {
                    return false;
                }
                return NumberInterval.this.getLowerBound().checkAsLowerBound(entry.getValue()) && NumberInterval.this.getUpperBound().checkAsUpperBound(entry.getValue());
            }

            @Override
            public Boolean handle(LongEntry entry) {
                if (!entry.getValue().getClass().equals(NumberInterval.this.type)) {
                    return false;
                }
                return NumberInterval.this.getLowerBound().checkAsLowerBound(entry.getValue()) && NumberInterval.this.getUpperBound().checkAsUpperBound(entry.getValue());
            }

            @Override
            public Boolean handle(ShortEntry entry) {
                if (!entry.getValue().getClass().equals(NumberInterval.this.type)) {
                    return false;
                }
                return NumberInterval.this.getLowerBound().checkAsLowerBound(entry.getValue()) && NumberInterval.this.getUpperBound().checkAsUpperBound(entry.getValue());
            }

            @Override
            protected Boolean defaultHandle(Entry entry) {
                return false;
            }
        });
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.lowerBound == null ? 0 : this.lowerBound.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.upperBound == null ? 0 : this.upperBound.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NumberInterval other = (NumberInterval)obj;
        if (this.lowerBound == null ? other.lowerBound != null : !this.lowerBound.equals(other.lowerBound)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.upperBound == null ? other.upperBound != null : !this.upperBound.equals(other.upperBound));
    }

    public String toString() {
        return BRACKET_ROUND_OPEN + this.getType().toString() + BRACKET_ROUND_CLOSE + this.lowerBoundAffiliationToString() + this.getLowerBound().toString() + ", " + this.getUpperBound().toString() + this.upperBoundAffiliationToString();
    }

    private String lowerBoundAffiliationToString() {
        return this.getLowerBound().getAffiliation().accept(new IntervalAffiliationReturnVisitor<String>(){

            @Override
            public String handle(Inclusive inclusive) {
                return NumberInterval.BRACKET_EDGE_OPEN;
            }

            @Override
            public String handle(Exclusive exclusive) {
                return NumberInterval.BRACKET_ROUND_OPEN;
            }
        });
    }

    private String upperBoundAffiliationToString() {
        return this.getUpperBound().getAffiliation().accept(new IntervalAffiliationReturnVisitor<String>(){

            @Override
            public String handle(Inclusive inclusive) {
                return NumberInterval.BRACKET_EDGE_CLOSE;
            }

            @Override
            public String handle(Exclusive exclusive) {
                return NumberInterval.BRACKET_ROUND_CLOSE;
            }
        });
    }
}

