/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.hfp416.spaces.template;

import de.fhdw.hfp416.spaces.entry.Entry;
import de.fhdw.hfp416.spaces.entry.primitiveentry.CharacterEntry;
import de.fhdw.hfp416.spaces.entry.primitiveentry.StringEntry;
import de.fhdw.hfp416.spaces.entry.visitor.EntryReturnDefaultVisitor;
import de.fhdw.hfp416.spaces.template.PrimitiveTemplate;
import de.fhdw.hfp416.spaces.template.Template;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegularExpressionTemplate
extends PrimitiveTemplate {
    private final Pattern pattern;
    private static final String CHARACTER_NAME = Character.class.getSimpleName();
    private static final String CHARACTER_NAMESPACE = Character.class.getPackage().getName();
    private static final String STRING_NAME = String.class.getSimpleName();
    private static final String STRING_NAMESPACE = String.class.getPackage().getName();

    public RegularExpressionTemplate(String regExp) {
        this.pattern = Pattern.compile(regExp);
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    protected boolean matchNameAndNamespace(Entry entry) {
        return entry.getName().equals(CHARACTER_NAME) && entry.getNamespace().equals(CHARACTER_NAMESPACE) || entry.getName().equals(STRING_NAME) && entry.getNamespace().equals(STRING_NAMESPACE);
    }

    @Override
    protected boolean matchAttributes(Entry entry, Map<Template, Entry> alreadyCheckedEntries) {
        return entry.accept(new EntryReturnDefaultVisitor<Boolean>(){

            @Override
            public Boolean handle(CharacterEntry entry) {
                String value = entry.getValue().toString();
                Matcher m = RegularExpressionTemplate.this.getPattern().matcher(value);
                return m.matches();
            }

            @Override
            public Boolean handle(StringEntry entry) {
                String value = entry.getValue();
                Matcher m = RegularExpressionTemplate.this.getPattern().matcher(value);
                return m.matches();
            }

            @Override
            protected Boolean defaultHandle(Entry entry) {
                return false;
            }
        });
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.pattern == null ? 0 : this.pattern.pattern().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegularExpressionTemplate other = (RegularExpressionTemplate)obj;
        return !(this.pattern == null ? other.pattern != null : !this.pattern.pattern().equals(other.pattern.pattern()));
    }

    public String toString() {
        return "RegularExpressionTemplate [pattern=" + this.pattern.pattern() + "]";
    }
}

