/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.hfp416.spaces.entry;

import de.fhdw.hfp416.spaces.entry.Entry;
import de.fhdw.hfp416.spaces.entry.ObjectEntry;
import de.fhdw.hfp416.spaces.entry.visitor.IEntryExceptionVisitor;
import de.fhdw.hfp416.spaces.entry.visitor.IEntryReturnExceptionVisitor;
import de.fhdw.hfp416.spaces.entry.visitor.IEntryReturnVisitor;
import de.fhdw.hfp416.spaces.entry.visitor.IEntryVisitor;
import de.fhdw.hfp416.spaces.exception.ReferenceAlreadySetException;

public class ReferenceEntry
extends Entry {
    private ReferenceEntryState state;

    public ReferenceEntry(ObjectEntry reference) {
        super(null, null);
        this.state = reference != null ? new ReferenceSetState(this, reference) : new NoReferenceState(this);
    }

    @Override
    public String getName() {
        return this.getReference().getName();
    }

    @Override
    public String getNamespace() {
        return this.getReference().getNamespace();
    }

    public ObjectEntry getReference() {
        return this.state.getReference();
    }

    public void setReference(ObjectEntry reference) throws ReferenceAlreadySetException {
        this.state.setReference(reference);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.getReference() == null ? 0 : this.getReference().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReferenceEntry other = (ReferenceEntry)obj;
        return !(this.getReference() == null ? other.getReference() != null : !this.getReference().equals(other.getReference()));
    }

    public String toString() {
        return "ReferenceEntry";
    }

    @Override
    public void accept(IEntryVisitor visitor) {
        visitor.handle(this);
    }

    @Override
    public <T> T accept(IEntryReturnVisitor<T> visitor) {
        return visitor.handle(this);
    }

    @Override
    public <E extends Exception> void accept(IEntryExceptionVisitor<E> visitor) throws E {
        visitor.handle(this);
    }

    @Override
    public <T, E extends Exception> T accept(IEntryReturnExceptionVisitor<T, E> visitor) throws E {
        return visitor.handle(this);
    }

    private class ReferenceSetState
    extends ReferenceEntryState {
        private final ObjectEntry reference;

        private ReferenceSetState(ReferenceEntry myEntry, ObjectEntry reference) {
            super(myEntry);
            this.reference = reference;
        }

        @Override
        protected ObjectEntry getReference() {
            return this.reference;
        }

        @Override
        protected void setReference(ObjectEntry reference) throws ReferenceAlreadySetException {
            throw new ReferenceAlreadySetException(String.format("The reference has already been set to: %s", this.getReference().toString()));
        }
    }

    private class NoReferenceState
    extends ReferenceEntryState {
        private NoReferenceState(ReferenceEntry myEntry) {
            super(myEntry);
        }

        @Override
        protected ObjectEntry getReference() {
            return null;
        }

        @Override
        protected void setReference(ObjectEntry reference) {
            if (reference != null) {
                this.myEntry.state = new ReferenceSetState(this.myEntry, reference);
            }
        }
    }

    private abstract class ReferenceEntryState {
        protected final ReferenceEntry myEntry;

        private ReferenceEntryState(ReferenceEntry myEntry) {
            this.myEntry = myEntry;
        }

        protected abstract ObjectEntry getReference();

        protected abstract void setReference(ObjectEntry var1) throws ReferenceAlreadySetException;
    }
}

