/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.hfp416.spaces.template.interval;

import de.fhdw.hfp416.spaces.template.interval.Exclusive;
import de.fhdw.hfp416.spaces.template.interval.Inclusive;
import de.fhdw.hfp416.spaces.template.interval.IntervalAffiliation;
import de.fhdw.hfp416.spaces.template.interval.IntervalAffiliationReturnVisitor;
import de.fhdw.hfp416.spaces.template.interval.IntervalBoundReturnVisitor;
import de.fhdw.hfp416.spaces.template.interval.IntervalBoundVisitor;

public abstract class IntervalBound<N extends Number> {
    private IntervalAffiliation affiliation;

    public IntervalBound() {
        this(new Inclusive());
    }

    public IntervalBound(IntervalAffiliation affiliation) {
        this.setAffiliation(affiliation);
    }

    public boolean checkAsLowerBound(final N value) {
        return this.getAffiliation().accept(new IntervalAffiliationReturnVisitor<Boolean>(){

            @Override
            public Boolean handle(Inclusive inclusive) {
                return IntervalBound.this.isSmallerOrEqual(value);
            }

            @Override
            public Boolean handle(Exclusive exclusive) {
                return IntervalBound.this.isSmaller(value);
            }
        });
    }

    public boolean checkAsUpperBound(final N value) {
        return this.getAffiliation().accept(new IntervalAffiliationReturnVisitor<Boolean>(){

            @Override
            public Boolean handle(Inclusive inclusive) {
                return IntervalBound.this.isGreaterOrEqual(value);
            }

            @Override
            public Boolean handle(Exclusive exclusive) {
                return IntervalBound.this.isGreater(value);
            }
        });
    }

    public abstract boolean isSmallerOrEqual(N var1);

    public abstract boolean isSmallerOrEqual(IntervalBound<N> var1);

    public abstract boolean isSmaller(N var1);

    public abstract boolean isSmaller(IntervalBound<N> var1);

    public abstract boolean isGreaterOrEqual(N var1);

    public abstract boolean isGreaterOrEqual(IntervalBound<N> var1);

    public abstract boolean isGreater(N var1);

    public abstract boolean isGreater(IntervalBound<N> var1);

    public abstract void accept(IntervalBoundVisitor<N> var1);

    public abstract <T> T accept(IntervalBoundReturnVisitor<T, N> var1);

    public IntervalAffiliation getAffiliation() {
        return this.affiliation;
    }

    public void setAffiliation(IntervalAffiliation affiliation) {
        this.affiliation = affiliation;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.affiliation == null ? 0 : this.affiliation.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntervalBound other = (IntervalBound)obj;
        return !(this.affiliation == null ? other.affiliation != null : !this.affiliation.equals(other.affiliation));
    }

    protected boolean isInclusive() {
        return this.getAffiliation().accept(new IntervalAffiliationReturnVisitor<Boolean>(){

            @Override
            public Boolean handle(Inclusive inclusive) {
                return true;
            }

            @Override
            public Boolean handle(Exclusive exclusive) {
                return false;
            }
        });
    }
}

