/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.hfp416.spaces.util.future;

import de.fhdw.hfp416.spaces.time.timepoint.InfiniteTimepoint;
import de.fhdw.hfp416.spaces.time.timepoint.Timepoint;
import de.fhdw.hfp416.spaces.time.timespan.ConcreteTimespan;
import de.fhdw.hfp416.spaces.time.timespan.InfiniteTimespan;
import de.fhdw.hfp416.spaces.time.timespan.Timespan;
import de.fhdw.hfp416.spaces.time.timespan.TimespanExceptionVisitor;
import de.fhdw.hfp416.spaces.util.future.FoundFutureState;
import de.fhdw.hfp416.spaces.util.future.Future;
import de.fhdw.hfp416.spaces.util.future.FutureReturnrequestAbortedException;
import de.fhdw.hfp416.spaces.util.future.FutureState;
import de.fhdw.hfp416.spaces.util.future.NotFoundFutureState;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Instant;
import java.util.NoSuchElementException;

public class SearchingFutureState<T>
extends FutureState<T> {
    private Timepoint expiration = new InfiniteTimepoint();
    private final Object lock = new Object();

    public SearchingFutureState(Future<T> future) {
        super(future);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T get() throws FutureReturnrequestAbortedException {
        Object object = this.lock;
        synchronized (object) {
            while (this.getFuture().getState() == this) {
                Timespan remainingTime = this.expiration.timespanBetween(Instant.now());
                if (remainingTime.isNegative()) {
                    this.abort();
                    continue;
                }
                try {
                    this.wait(remainingTime);
                }
                catch (InterruptedException interruptedException) {}
            }
            return this.getFuture().get();
        }
    }

    private void wait(Timespan timespan) throws InterruptedException {
        timespan.accept(new TimespanExceptionVisitor<InterruptedException>(){

            @Override
            @SuppressFBWarnings(value={"WA_NOT_IN_LOOP"})
            public void handle(ConcreteTimespan timespan) throws InterruptedException {
                SearchingFutureState.this.lock.wait(timespan.getDuration().toMillis());
            }

            @Override
            @SuppressFBWarnings(value={"WA_NOT_IN_LOOP"})
            public void handle(InfiniteTimespan timespan) throws InterruptedException {
                SearchingFutureState.this.lock.wait();
            }
        });
    }

    @Override
    public T getWithoutBlocking() throws FutureReturnrequestAbortedException, NoSuchElementException {
        throw new NoSuchElementException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(T object) {
        this.getFuture().setState(new FoundFutureState(this.getFuture(), object));
        Object object2 = this.lock;
        synchronized (object2) {
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() {
        this.getFuture().setState(new NotFoundFutureState(this.getFuture()));
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setExpireTimepoint(Timepoint timepoint) {
        this.expiration = timepoint;
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }
}

