package de.fhdw.wtf.context.model.collections;

import java.util.Iterator;

import de.fhdw.wtf.context.core.TransactionManager;
import de.fhdw.wtf.context.model.Anything;
import de.fhdw.wtf.context.model.collections.functors.Predicate;
import de.fhdw.wtf.context.model.collections.functors.Procedure;
import de.fhdw.wtf.persistence.meta.UserObject;

/**
 * This class is a Container for Collections. So collections of collections can be created.
 * 
 * @param <T>
 *            Type of the contained elements.
 */
public class PersistentList<T extends Anything> extends MutableList<T> {
	
	/**
	 * Manages the links of this persistent list.
	 */
	private transient PersistentListWithLinks<T> links;
	/**
	 * Name of the underlying database association representing the 0..* relation.
	 */
	public static final String linksAssociationName = "links";
	
	/**
	 * Creates an empty PersistentList.
	 */
	public PersistentList() {
		// nothing to do
	}
	
	@Override
	protected void setObject(final UserObject object) {
		super.setObject(object);
		final String assocName = PersistentList.class.getName() + "." + linksAssociationName;
		this.links =
				new PersistentListWithLinks<>(TransactionManager.getContext().get(this.getObject(), assocName),
						assocName, this.getObject());
	}
	
	@Override
	public Collection<T> union(final Collection<? extends T> otherCollection) {
		this.links.union(otherCollection);
		return this;
	}
	
	@Override
	public boolean contains(final T element) {
		return this.links.contains(element);
	}
	
	@Override
	public boolean isEmpty() {
		return this.links.isEmpty();
	}
	
	@Override
	public Iterator<T> iterator() {
		return this.links.iterator();
	}
	
	@Override
	public void insert(final T element) {
		this.links.insert(element);
		
	}
	
	@Override
	public void apply(final Procedure<T> procedure) {
		this.links.apply(procedure);
		
	}
	
	@Override
	public void remove(final Predicate<T> predicate) {
		this.links.remove(predicate);
		
	}
	
	@Override
	public ImmutableCollection<T> copy() {
		return this.links.copy();
	}
	
	@Override
	public String toString() {
		return this.links.toString();
	}
	
}
