package de.fhdw.wtf.context.core;

import de.fhdw.wtf.persistence.facade.ObjectFacade;
import de.fhdw.wtf.persistence.facade.TypeManager;

/**
 * This method represent an abstraction over Persistence and Revision Context, because both classes need a connection to
 * the Database, this means a Type Manager and the Object Facade.
 * 
 */
public abstract class ContextWithDatabaseAccess extends Context {
	
	/**
	 * The Type Manager, which holds knowledge about all existing Types and associations in the model.
	 */
	protected final TypeManager typeManager;
	/**
	 * The Facade towards the database.
	 */
	protected final ObjectFacade objectFacade;
	
	/**
	 * Protected superclass constructor.
	 * 
	 * @param objectFacade
	 *            A reference to Object Facade.
	 */
	protected ContextWithDatabaseAccess(final ObjectFacade objectFacade) {
		this.objectFacade = objectFacade;
		this.typeManager = objectFacade.getTypeManager();
	}
	
}
