package de.fhdw.wtf.context.core;

import de.fhdw.wtf.context.model.Anything;
import de.fhdw.wtf.persistence.meta.Object;

/**
 * This class represent to supertype to all Object Factories. A Factory is GoF Pattern, which is used to provide an
 * instance of a class by given meta-information.
 * 
 */
public abstract class ObjectFactory {
	
	/**
	 * Creates an Object which type is a subtype to Anything.
	 * 
	 * @param object
	 *            The Object Meta information, needed to provide the type.
	 * @return Provides a new instance for a subtype of Anything.
	 */
	public abstract Anything createObject(Object object);
	
}
