package de.fhdw.wtf.context.exception;

/**
 * This class represents a Framework Exception which occurs, when the application could not be started because the class
 * for a DatabaseManagerFactory could not be instantiated.
 * 
 */
public class DatabaseManagerFactoryNotInstantiableException extends FrameworkException {
	
	/**
	 * The reason for not instantiating because the given class is abstract or not a descendant of
	 * DatabaseManagerFactory.
	 */
	public static final String CLASS_IS_A_CONCRETE_DATABASE_MANAGER_FACTORY_REASON =
			"The given class is abstract or not a descendant of DatabaseManagerFactory.";
	
	/**
	 * The message describing this exception.
	 */
	private static final String MESSAGE = "Couldn't instantiate a subclass of DatabaseManagerFactory: ";
	
	/**
	 * Creates a DatabaseManagerFactoryNotInstantiableException.
	 * 
	 * @param reason
	 *            The key which couldn't be mapped to a subclass of DatabaseManagerFactory.
	 */
	public DatabaseManagerFactoryNotInstantiableException(final String reason) {
		super(DatabaseManagerFactoryNotInstantiableException.MESSAGE + reason);
	}
	
}
