/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.context.model.collections;

import de.fhdw.wtf.context.core.TransactionManager;
import de.fhdw.wtf.context.model.Anything;
import de.fhdw.wtf.context.model.collections.Collection;
import de.fhdw.wtf.context.model.collections.ImmutableCollection;
import de.fhdw.wtf.context.model.collections.MutableList;
import de.fhdw.wtf.context.model.collections.PersistentListWithLinks;
import de.fhdw.wtf.context.model.collections.functors.Predicate;
import de.fhdw.wtf.context.model.collections.functors.Procedure;
import de.fhdw.wtf.persistence.meta.UserObject;
import java.util.Iterator;

public class PersistentList<T extends Anything>
extends MutableList<T> {
    private transient PersistentListWithLinks<T> links;
    public static final String linksAssociationName = "links";

    @Override
    protected void setObject(UserObject object) {
        super.setObject(object);
        String assocName = PersistentList.class.getName() + "." + linksAssociationName;
        this.links = new PersistentListWithLinks(TransactionManager.getContext().get(this.getObject(), assocName), assocName, this.getObject());
    }

    @Override
    public Collection<T> union(Collection<? extends T> otherCollection) {
        this.links.union(otherCollection);
        return this;
    }

    @Override
    public boolean contains(T element) {
        return this.links.contains(element);
    }

    @Override
    public boolean isEmpty() {
        return this.links.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.links.iterator();
    }

    @Override
    public void insert(T element) {
        this.links.insert(element);
    }

    @Override
    public void apply(Procedure<T> procedure) {
        this.links.apply(procedure);
    }

    @Override
    public void remove(Predicate<T> predicate) {
        this.links.remove(predicate);
    }

    @Override
    public ImmutableCollection<T> copy() {
        return this.links.copy();
    }

    public String toString() {
        return this.links.toString();
    }
}

