package de.fhdw.wtf.context.core;

import de.fhdw.wtf.context.model.Anything;

/**
 * Encapsulates field change events.
 */
public class FieldChangeEvent implements ObserverEvent {
	
	/**
	 * The name of the associated field.
	 */
	private final String fieldName;
	
	/**
	 * The new value of the field.
	 */
	private final Anything newValue;
	
	/**
	 * Creates a FieldChangeEvent.
	 * 
	 * @param fieldName
	 *            The name of the associated field.
	 * @param newValue
	 *            The new value of the field.
	 */
	public FieldChangeEvent(final String fieldName, final Anything newValue) {
		super();
		this.fieldName = fieldName;
		this.newValue = newValue;
	}
	
	/**
	 * Returns the name of the associated field.
	 * 
	 * @return The name of the associated field.
	 */
	public String getFieldName() {
		return this.fieldName;
	}
	
	/**
	 * Returns the new value of the field.
	 * 
	 * @return The new value of the field.
	 */
	public Anything getNewValue() {
		return this.newValue;
	}
	
}
