package de.fhdw.wtf.context.exception;

/**
 * This class represents a framework Exception, which occurs when persistence layer operations are used when being
 * outside of Persistence Context.
 * 
 */
public class OutOfScopeException extends FrameworkException {
	
	/**
	 * Exception message.
	 */
	private static final String MESSAGE = "Called from outside a persistence Context in Thread: ";
	/**
	 * The exception's serial ID.
	 */
	private static final long serialVersionUID = 1L;
	
	/**
	 * Creates an OutOfScopeException.
	 * 
	 * @param threadName
	 *            The name of the culprit thread.
	 */
	public OutOfScopeException(final String threadName) {
		super(MESSAGE + threadName);
	}
}
