/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.context.core;

import de.fhdw.wtf.context.core.IntegerFactory;
import de.fhdw.wtf.context.core.ObjectFactory;
import de.fhdw.wtf.context.core.StringFactory;
import de.fhdw.wtf.context.model.Anything;
import de.fhdw.wtf.context.model.UserObjectFactory;
import de.fhdw.wtf.persistence.exception.RuntimePersistenceException;
import de.fhdw.wtf.persistence.exception.TypeOrAssociationNotFoundException;
import de.fhdw.wtf.persistence.facade.TypeManager;
import de.fhdw.wtf.persistence.meta.Object;
import java.util.HashMap;
import java.util.Map;

public final class ObjectFactoryProvider {
    private final Map<Long, ObjectFactory> factories = new HashMap<Long, ObjectFactory>();
    private static ObjectFactoryProvider instance = null;

    private ObjectFactoryProvider() {
        this.factories.put(1L, IntegerFactory.create());
        this.factories.put(2L, StringFactory.instance());
    }

    public void registerTypeFactory(TypeManager typeManager, String fullQualifiedClassName, UserObjectFactory factory) throws TypeOrAssociationNotFoundException {
        this.factories.put(typeManager.getTypeforName(fullQualifiedClassName).getId(), factory);
    }

    public static synchronized ObjectFactoryProvider instance() {
        if (instance == null) {
            instance = new ObjectFactoryProvider();
        }
        return instance;
    }

    public Anything createObject(Object object) {
        if (!this.factories.containsKey(object.getInstanceOf().getId())) {
            throw new RuntimePersistenceException();
        }
        return this.factories.get(object.getInstanceOf().getId()).createObject(object);
    }
}

