package de.fhdw.wtf.context.core;

import de.fhdw.wtf.context.exception.FrameworkException;
import de.fhdw.wtf.context.model.Anything;
import de.fhdw.wtf.context.model.Str;
import de.fhdw.wtf.persistence.meta.Object;
import de.fhdw.wtf.persistence.meta.StringValue;

/**
 * An implementation of an ObjectFactory which creates Str objects.
 */
public class StringFactory extends ObjectFactory {
	
	/**
	 * The singleton instance of this class.
	 */
	private static StringFactory instance = null;
	
	@Override
	public Anything createObject(final Object object) {
		if (object instanceof StringValue) {
			final Str result = new Str((StringValue) object);
			return result;
		} else {
			throw new FrameworkException("StringFactory.createObject() called on object of type "
					+ object.getClass().getName());
		}
	}
	
	/**
	 * Returns the singleton instance of this class.
	 * 
	 * @return The singleton instance of this class.
	 */
	public static synchronized StringFactory instance() {
		if (instance == null) {
			instance = new StringFactory();
		}
		return instance;
	}
	
}
