package de.fhdw.wtf.context.exception;

/**
 * This class represents a Framework Exception which occurs when someone tries to manipulate Data during a Revision.
 * 
 */
public class ManipulationDuringRevisionException extends FrameworkException {
	
	/**
	 * Exception message.
	 */
	private static final String MESSAGE = "Data Manipulation during a revision is not allowed";
	
	/**
	 * Creates a ManipulationDuringRevisionException.
	 */
	public ManipulationDuringRevisionException() {
		super(MESSAGE);
	}
	
	/**
	 * The exception's serial ID.
	 */
	private static final long serialVersionUID = 1L;
	
}
