package de.fhdw.wtf.context.core;

import java.util.Date;

import de.fhdw.wtf.persistence.exception.ClassFacadeUninitializedException;
import de.fhdw.wtf.persistence.exception.RuntimePersistenceException;

/**
 * This class represents the abstract supertype to all revision User Access. During a revision access there is no
 * possibility to manipulate data therefore the access is read only.
 * 
 */
public abstract class Revision extends UserAccess {
	
	/**
	 * The underlying time stamp.
	 */
	private final Date timestamp;
	
	/**
	 * Creates a revision to a given time stamp.
	 * 
	 * @param timestamp
	 *            A millisecond accurate time stamp.
	 */
	public Revision(final Date timestamp) {
		super();
		this.timestamp = new Date(timestamp.getTime());
	}
	
	@Override
	public void publish() {
		try {
			TransactionManager.setContext(new RevisionContext(ApplicationContainer.getInstance().getDatabaseManager()
					.getObjectFacade(), this.timestamp));
		} catch (final ClassFacadeUninitializedException e) {
			Logger.getInstance().log(e);
			throw new RuntimePersistenceException(e);
		}
	}
	
}
