/*
 * Decompiled with CFR 0.152.
 */
package test.integration;

import de.fhdw.wtf.context.core.Context;
import de.fhdw.wtf.context.core.PersistenceContext;
import de.fhdw.wtf.context.core.TransactionManager;
import de.fhdw.wtf.context.model.Str;
import de.fhdw.wtf.persistence.exception.PersistenceException;
import generated.model.de.fhdw.partner.Haus;
import generated.model.de.fhdw.partner.NatuerlichePerson;
import generated.model.de.fhdw.partner.service.HausService;
import generated.model.de.fhdw.partner.service.PersonService;
import org.junit.Assert;
import org.junit.Test;
import test.integration.TestAnyTypeCache;
import test.integration.TestBase;
import test.integration.TestBaseWithDB;

public class TestAnyTypeCacheWithDB
extends TestAnyTypeCache {
    @Override
    protected TestBase genTestBase() {
        return new TestBaseWithDB();
    }

    @Override
    protected TestBaseWithDB getTestBase() {
        return (TestBaseWithDB)super.getTestBase();
    }

    @Override
    protected PersonService getPersonService() throws PersistenceException {
        TransactionManager.setContext((Context)new PersistenceContext(this.getTestBase().getObjectFacade(), this.getTestBase().getObjectFacade().provideAdhocTransaction()));
        PersonService personService = new PersonService();
        TransactionManager.commit();
        return personService;
    }

    @Override
    protected HausService getHausService() throws PersistenceException {
        TransactionManager.setContext((Context)new PersistenceContext(this.getTestBase().getObjectFacade(), this.getTestBase().getObjectFacade().provideAdhocTransaction()));
        HausService hausService = new HausService();
        TransactionManager.commit();
        return hausService;
    }

    @Test
    public void testCacheWithContextSwitchService() throws PersistenceException {
        TransactionManager.setContext((Context)new PersistenceContext(this.getTestBase().getObjectFacade(), this.getTestBase().getObjectFacade().provideAdhocTransaction()));
        HausService hausService = this.getHausService();
        hausService.publish();
        PersonService personService = this.getPersonService();
        personService.publish();
        Haus miethaus = hausService.createHaus(new Str("3C"));
        NatuerlichePerson person1 = personService.createPerson(this.alexr);
        person1.setWohnhaft(miethaus);
        NatuerlichePerson person2 = personService.createPerson(this.patrick);
        person2.setWohnhaft(miethaus);
        Str Person1WohnhaftHausNr = person1.getWohnhaft().getHausNummer();
        String objectIdPerson1Haus = Integer.toHexString(System.identityHashCode((Object)person1.getWohnhaft()));
        TransactionManager.commit();
        HausService hausService2 = this.getHausService();
        hausService2.publish();
        PersonService personService2 = this.getPersonService();
        personService2.publish();
        person1.getWohnhaft().setHausNummer(new Str("1337"));
        Str Person2WohnhaftHausNr = person2.getWohnhaft().getHausNummer();
        String objectIdPerson2Haus = Integer.toHexString(System.identityHashCode((Object)person2.getWohnhaft()));
        Assert.assertNotEquals((Object)Person1WohnhaftHausNr, (Object)Person2WohnhaftHausNr);
        Assert.assertEquals((Object)objectIdPerson1Haus, (Object)objectIdPerson2Haus);
    }
}

