package de.fhdw.wtf.context.model.collections.functors;

import de.fhdw.wtf.context.model.Anything;

/**
 * This interface represents a function +: U x T -> U, where + has an neutral element n: -> U.
 * 
 * @param <T>
 *            A subtype of Anything, which is the second operand of the operation.
 * @param <U>
 *            A subtype of Antyhing, which is the first operand and also the result of the operation.
 */
public interface Operator<T extends Anything, U extends Anything> {
	
	/**
	 * This method represents the neutral element of the operation. This means that a + n = a where is any element of
	 * Type U.
	 * 
	 * @return Provides the neutral element of + which is of type U.
	 */
	U n();
	
	/**
	 * This method represents the operation +.
	 * 
	 * @param first
	 *            The first operand of type U.
	 * @param second
	 *            The second operand of type T.
	 * @return the result of + which is of type U.
	 */
	U add(U first, T second);
}
