/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.context.core;

import de.fhdw.wtf.context.core.ApplicationStarter;
import de.fhdw.wtf.context.core.Logger;
import de.fhdw.wtf.context.core.LoginService;
import de.fhdw.wtf.context.core.ObjectFactoryProvider;
import de.fhdw.wtf.context.exception.FrameworkException;
import de.fhdw.wtf.persistence.facade.AuthorizationFacade;
import de.fhdw.wtf.persistence.facade.DatabaseManager;
import de.fhdw.wtf.persistence.facade.OracleAuthorizationFacadeImplementation;
import de.fhdw.wtf.persistence.facade.OracleDatabaseManager;

public final class ApplicationContainer {
    private static ApplicationContainer instance = null;
    private String usedDatabaseManagerFactoryName = null;
    private String appName;
    private DatabaseManager databaseManager;
    private Logger logger;
    private ObjectFactoryProvider factoryProvider;

    public static synchronized ApplicationContainer getInstance() {
        if (instance == null) {
            instance = new ApplicationContainer();
        }
        return instance;
    }

    private ApplicationContainer() {
    }

    public String getAppName() {
        return this.appName;
    }

    void setAppName(String appName) {
        this.appName = appName;
    }

    public String getUsedDatabaseManagerFactoryName() {
        return this.usedDatabaseManagerFactoryName;
    }

    void setUsedDatabaseManagerFactoryName(String usedDatabaseManagerFactoryName) {
        this.usedDatabaseManagerFactoryName = usedDatabaseManagerFactoryName;
    }

    public ObjectFactoryProvider getFactoryProvider() {
        return this.factoryProvider;
    }

    void setFactoryProvider(ObjectFactoryProvider factoryProvider) {
        this.factoryProvider = factoryProvider;
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    void setDatabaseManager(DatabaseManager databaseManager) {
        this.databaseManager = databaseManager;
    }

    public Logger getLogger() {
        return this.logger;
    }

    void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoginService provideLoginService() {
        if (this.usedDatabaseManagerFactoryName.equals(ApplicationStarter.ORACLE_DATABASE_MANAGER_FACTORY_NAME)) {
            return new LoginService((AuthorizationFacade)new OracleAuthorizationFacadeImplementation(this.getAppName(), (OracleDatabaseManager)this.getDatabaseManager()));
        }
        throw new FrameworkException("Database " + this.usedDatabaseManagerFactoryName + " is not supported");
    }
}

