/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.context.core;

import de.fhdw.wtf.context.core.ContextWithDatabaseAccess;
import de.fhdw.wtf.context.core.Logger;
import de.fhdw.wtf.persistence.exception.ObjectNotFoundException;
import de.fhdw.wtf.persistence.exception.PersistenceException;
import de.fhdw.wtf.persistence.exception.RuntimePersistenceException;
import de.fhdw.wtf.persistence.facade.ObjectFacade;
import de.fhdw.wtf.persistence.facade.TypeManager;
import de.fhdw.wtf.persistence.meta.Association;
import de.fhdw.wtf.persistence.meta.Link;
import de.fhdw.wtf.persistence.meta.MapLink;
import de.fhdw.wtf.persistence.meta.Object;
import de.fhdw.wtf.persistence.meta.Transaction;
import de.fhdw.wtf.persistence.meta.UnidirectionalLink;
import de.fhdw.wtf.persistence.meta.UserObject;
import de.fhdw.wtf.persistence.meta.UserType;
import de.fhdw.wtf.persistence.utils.Tuple;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashSet;

public class PersistenceContext
extends ContextWithDatabaseAccess {
    public final Transaction transaction;

    public PersistenceContext(ObjectFacade objectFacade, Transaction transaction) {
        super(objectFacade);
        this.transaction = transaction;
    }

    @Override
    public Collection<UserObject> find(String associationName, String value) {
        try {
            return this.objectFacade.find((Association)this.typeManager.getUnidirectionalAssociationForName(associationName), value, this.transaction);
        }
        catch (PersistenceException e) {
            Logger.getInstance().log(e);
            throw new RuntimePersistenceException();
        }
    }

    @Override
    public Collection<UserObject> find(String associationName, BigInteger value) {
        try {
            return this.objectFacade.find((Association)this.typeManager.getUnidirectionalAssociationForName(associationName), value, this.transaction);
        }
        catch (PersistenceException e) {
            Logger.getInstance().log(e);
            throw new RuntimePersistenceException();
        }
    }

    @Override
    public Collection<Tuple<UnidirectionalLink, UserObject>> inverseGet(String associationName, UserObject object) {
        try {
            return this.objectFacade.inverseGet(object, this.typeManager.getUnidirectionalAssociationForName(associationName), this.transaction);
        }
        catch (PersistenceException e) {
            Logger.getInstance().log(e);
            throw new RuntimePersistenceException();
        }
    }

    @Override
    public Collection<Tuple<UnidirectionalLink, Object>> get(UserObject object, String associationName) {
        try {
            return this.objectFacade.get(object, this.typeManager.getUnidirectionalAssociationForName(associationName), this.transaction);
        }
        catch (PersistenceException e) {
            Logger.getInstance().log(e);
            throw new RuntimePersistenceException();
        }
    }

    @Override
    public Collection<Tuple<MapLink, Object>> get(UserObject object, String associationName, String key) {
        try {
            return this.objectFacade.get(object, this.typeManager.getMapAssociationForName(associationName), key, this.transaction);
        }
        catch (ObjectNotFoundException e) {
            return new HashSet<Tuple<MapLink, Object>>();
        }
        catch (PersistenceException e) {
            Logger.getInstance().log(e);
            throw new RuntimePersistenceException();
        }
    }

    @Override
    public Collection<Tuple<MapLink, Object>> get(UserObject object, String associationName, BigInteger key) {
        try {
            return this.objectFacade.get(object, this.typeManager.getMapAssociationForName(associationName), key, this.transaction);
        }
        catch (ObjectNotFoundException e) {
            return new HashSet<Tuple<MapLink, Object>>();
        }
        catch (PersistenceException e) {
            Logger.getInstance().log(e);
            throw new RuntimePersistenceException();
        }
    }

    @Override
    public Collection<Tuple<MapLink, Object>> get(UserObject object, String associationName, UserObject key) {
        try {
            return this.objectFacade.get(object, this.typeManager.getMapAssociationForName(associationName), key, this.transaction);
        }
        catch (ObjectNotFoundException e) {
            return new HashSet<Tuple<MapLink, Object>>();
        }
        catch (PersistenceException e) {
            Logger.getInstance().log(e);
            throw new RuntimePersistenceException();
        }
    }

    @Override
    public UserObject create(String typeName) {
        try {
            return this.objectFacade.create((UserType)this.typeManager.getTypeforName(typeName), this.transaction);
        }
        catch (PersistenceException e) {
            Logger.getInstance().log(e);
            throw new RuntimePersistenceException();
        }
    }

    @Override
    public UnidirectionalLink set(UserObject object, String associationName, String val) {
        try {
            return this.objectFacade.set(object, this.typeManager.getUnidirectionalAssociationForName(associationName), val, this.transaction);
        }
        catch (PersistenceException e) {
            Logger.getInstance().log(e);
            throw new RuntimePersistenceException();
        }
    }

    @Override
    public UnidirectionalLink set(UserObject object, String associationName, BigInteger val) {
        try {
            return this.objectFacade.set(object, this.typeManager.getUnidirectionalAssociationForName(associationName), val, this.transaction);
        }
        catch (PersistenceException e) {
            Logger.getInstance().log(e);
            throw new RuntimePersistenceException();
        }
    }

    @Override
    public UnidirectionalLink set(UserObject object, String associationName, UserObject target) {
        try {
            return this.objectFacade.set(object, this.typeManager.getUnidirectionalAssociationForName(associationName), target, this.transaction);
        }
        catch (PersistenceException e) {
            Logger.getInstance().log(e);
            throw new RuntimePersistenceException();
        }
    }

    @Override
    public MapLink put(UserObject owner, String associationName, UserObject target, String key) {
        try {
            return this.objectFacade.put(owner, this.typeManager.getMapAssociationForName(associationName), target, key, this.transaction);
        }
        catch (PersistenceException e) {
            Logger.getInstance().log(e);
            throw new RuntimePersistenceException();
        }
    }

    @Override
    public MapLink put(UserObject owner, String associationName, BigInteger target, String key) {
        try {
            return this.objectFacade.put(owner, this.typeManager.getMapAssociationForName(associationName), target, key, this.transaction);
        }
        catch (PersistenceException e) {
            Logger.getInstance().log(e);
            throw new RuntimePersistenceException();
        }
    }

    @Override
    public MapLink put(UserObject owner, String associationName, String target, String key) {
        try {
            return this.objectFacade.put(owner, this.typeManager.getMapAssociationForName(associationName), target, key, this.transaction);
        }
        catch (PersistenceException e) {
            Logger.getInstance().log(e);
            throw new RuntimePersistenceException();
        }
    }

    @Override
    public MapLink put(UserObject owner, String associationName, UserObject target, BigInteger key) {
        try {
            return this.objectFacade.put(owner, this.typeManager.getMapAssociationForName(associationName), target, key, this.transaction);
        }
        catch (PersistenceException e) {
            Logger.getInstance().log(e);
            throw new RuntimePersistenceException();
        }
    }

    @Override
    public MapLink put(UserObject owner, String associationName, BigInteger target, BigInteger key) {
        try {
            return this.objectFacade.put(owner, this.typeManager.getMapAssociationForName(associationName), target, key, this.transaction);
        }
        catch (PersistenceException e) {
            Logger.getInstance().log(e);
            throw new RuntimePersistenceException();
        }
    }

    @Override
    public MapLink put(UserObject owner, String associationName, String target, BigInteger key) {
        try {
            return this.objectFacade.put(owner, this.typeManager.getMapAssociationForName(associationName), target, key, this.transaction);
        }
        catch (PersistenceException e) {
            Logger.getInstance().log(e);
            throw new RuntimePersistenceException();
        }
    }

    @Override
    public MapLink put(UserObject owner, String associationName, UserObject target, UserObject key) {
        try {
            return this.objectFacade.put(owner, this.typeManager.getMapAssociationForName(associationName), target, key, this.transaction);
        }
        catch (PersistenceException e) {
            Logger.getInstance().log(e);
            throw new RuntimePersistenceException();
        }
    }

    @Override
    public MapLink put(UserObject owner, String associationName, BigInteger target, UserObject key) {
        try {
            return this.objectFacade.put(owner, this.typeManager.getMapAssociationForName(associationName), target, key, this.transaction);
        }
        catch (PersistenceException e) {
            Logger.getInstance().log(e);
            throw new RuntimePersistenceException();
        }
    }

    @Override
    public MapLink put(UserObject owner, String associationName, String target, UserObject key) {
        try {
            return this.objectFacade.put(owner, this.typeManager.getMapAssociationForName(associationName), target, key, this.transaction);
        }
        catch (PersistenceException e) {
            Logger.getInstance().log(e);
            throw new RuntimePersistenceException();
        }
    }

    @Override
    public void commit() {
        try {
            this.objectFacade.commit(this.transaction);
        }
        catch (PersistenceException e) {
            Logger.getInstance().log(e);
            throw new RuntimePersistenceException();
        }
    }

    @Override
    public void rollback() {
        try {
            this.objectFacade.rollback(this.transaction);
        }
        catch (PersistenceException e) {
            Logger.getInstance().log(e);
            throw new RuntimePersistenceException();
        }
    }

    @Override
    public void savePoint() {
        try {
            this.objectFacade.savePoint(this.transaction);
        }
        catch (PersistenceException e) {
            Logger.getInstance().log(e);
            throw new RuntimePersistenceException();
        }
    }

    @Override
    public void rollbackToSavePoint() {
        try {
            this.objectFacade.rollbackToSavePoint(this.transaction);
        }
        catch (PersistenceException e) {
            Logger.getInstance().log(e);
            throw new RuntimePersistenceException();
        }
    }

    @Override
    public void unset(Link toUnset) {
        try {
            this.objectFacade.unset(toUnset, this.transaction);
        }
        catch (PersistenceException e) {
            Logger.getInstance().log(e);
            throw new RuntimePersistenceException();
        }
    }

    @Override
    public TypeManager getTypeManager() {
        return this.objectFacade.getTypeManager();
    }

    @Override
    public Collection<UserObject> getObjectsByType(String typeName) {
        try {
            return this.objectFacade.findAllObjects((UserType)this.typeManager.getTypeforName(typeName), this.transaction);
        }
        catch (PersistenceException e) {
            Logger.getInstance().log(e);
            throw new RuntimePersistenceException();
        }
    }

    @Override
    public UserObject checkout(long object) {
        try {
            UserObject result = this.objectFacade.checkUserObjectOut(object, this.transaction);
            return result;
        }
        catch (PersistenceException e) {
            Logger.getInstance().log(e);
            throw new RuntimePersistenceException();
        }
    }
}

