package de.fhdw.wtf.context.model.collections;

import java.util.Iterator;
import java.util.Vector;

import de.fhdw.wtf.context.model.Anything;
import de.fhdw.wtf.context.model.collections.functors.EquivalenceRelation;
import de.fhdw.wtf.context.model.collections.functors.Function;
import de.fhdw.wtf.context.model.collections.functors.Operator;
import de.fhdw.wtf.context.model.collections.functors.Predicate;
import de.fhdw.wtf.persistence.meta.UserObject;

/**
 * A class to represent a mutable list of userobjects with persistence integration.
 * 
 * @param <T>
 *            Any Type T, which is subtype of Anything.
 */
public class PersistentListWithUserObject<T extends Anything> implements ImmutableCollection<T>, Iterable<T> {
	
	/**
	 * The underlying collection of UserObjects.
	 */
	private final java.util.Collection<UserObject> objects;
	
	/**
	 * Creates a PersistentListWithUserObject.
	 * 
	 * @param objects
	 *            A collection of UserObjects.
	 */
	public PersistentListWithUserObject(final java.util.Collection<UserObject> objects) {
		super();
		this.objects = objects;
	}
	
	@Override
	public Collection<T> union(final Collection<? extends T> otherCollection) {
		return this.toList().union(otherCollection);
	}
	
	@Override
	public boolean contains(final T element) {
		return this.toList().contains(element);
	}
	
	@Override
	public ImmutableCollection<T> add(final T element) {
		return this.toList().add(element);
	}
	
	@Override
	public T front() {
		return this.toList().front();
	}
	
	@Override
	public ImmutableCollection<T> tail() {
		return this.toList().tail();
	}
	
	@Override
	public ImmutableCollection<T> reverse() {
		return this.toList().reverse();
	}
	
	@Override
	public <U extends Anything> ImmutableCollection<U> map(final Function<T, U> function) {
		return this.toList().map(function);
	}
	
	@Override
	public <U extends Anything> U reduce(final Operator<T, U> aggregation) {
		return this.toList().reduce(aggregation);
	}
	
	@Override
	public <U extends Anything> ImmutableCollection<U> reduceEquivalent(final EquivalenceRelation<T> equi,
			final Operator<T, U> aggregation) {
		return this.toList().reduceEquivalent(equi, aggregation);
	}
	
	@Override
	public ImmutableCollection<T> filter(final Predicate<T> predicate) {
		return this.toList().filter(predicate);
	}
	
	@Override
	public T find(final Predicate<T> predicate) {
		return this.toList().find(predicate);
	}
	
	/**
	 * Converts this list to an ImmutableCollection.
	 * 
	 * @return An ImmutableCollection with the same objects as this list.
	 */
	private ImmutableCollection<T> toList() {
		ImmutableCollection<T> result = new ImmutableList<>();
		final Iterator<T> iterator = this.iterator();
		while (iterator.hasNext()) {
			final T current = iterator.next();
			result = result.add(current);
		}
		return result;
	}
	
	@Override
	public boolean isEmpty() {
		return this.objects.isEmpty();
	}
	
	@Override
	public Iterator<T> iterator() {
		return new PersistenceIteratorWithObject<>(this.objects.iterator());
	}
	
	@Override
	public String toString() {
		final Vector<T> result = new Vector<>();
		final Iterator<T> i = this.iterator();
		while (i.hasNext()) {
			final T current = i.next();
			result.add(current);
		}
		return result.toString();
	}
	
}
