/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.context.core;

import de.fhdw.wtf.context.exception.FrameworkException;
import de.fhdw.wtf.persistence.exception.PersistenceException;
import de.fhdw.wtf.persistence.exception.RuntimePersistenceException;
import de.fhdw.wtf.persistence.facade.AuthorizationFacade;
import de.fhdw.wtf.persistence.meta.Mandant;
import de.fhdw.wtf.persistence.meta.Role;
import de.fhdw.wtf.persistence.meta.User;
import java.util.Collection;
import java.util.Set;
import java.util.Vector;

public class LoginService {
    private Mandant currentMandant;
    private final AuthorizationFacade facade;
    private Collection<Role> availableRoles;

    public LoginService(AuthorizationFacade facade) {
        this.facade = facade;
        try {
            this.availableRoles = facade.listAllRoles();
        }
        catch (PersistenceException e) {
            this.availableRoles = new Vector<Role>();
            e.printStackTrace();
        }
    }

    public Collection<User> getUsers() {
        this.checkRootLogin();
        try {
            return this.facade.getUsers();
        }
        catch (PersistenceException e) {
            throw new RuntimePersistenceException((Throwable)e);
        }
    }

    private void checkRootLogin() {
        if (this.currentMandant == null) {
            throw new FrameworkException("Root not logged in");
        }
    }

    public void addRole(User user, Role role) {
        this.checkRootLogin();
        try {
            this.facade.grantRoleToUser(user, role);
        }
        catch (PersistenceException e) {
            throw new RuntimePersistenceException((Throwable)e);
        }
    }

    public User createUser(String username, String password, String passwordConfirmation) {
        this.checkRootLogin();
        if (!password.equals(passwordConfirmation)) {
            throw new FrameworkException("You mispelled your password once");
        }
        try {
            return this.facade.createUser(username, password);
        }
        catch (PersistenceException e) {
            throw new RuntimePersistenceException((Throwable)e);
        }
    }

    public Collection<Role> getRoles() {
        this.checkRootLogin();
        return this.availableRoles;
    }

    public boolean isLoginCorrect(String mandant, String username, String password) {
        try {
            return this.facade.isPasswordCorrect(mandant, username, password);
        }
        catch (PersistenceException e) {
            throw new RuntimePersistenceException((Throwable)e);
        }
    }

    public void rootLogin(String mandant, String password) {
        Mandant m = new Mandant(mandant, password);
        try {
            this.facade.logIn(m);
            this.currentMandant = m;
        }
        catch (PersistenceException e) {
            throw new RuntimePersistenceException((Throwable)e);
        }
    }

    public Set<Role> getRolesFrom(User user) {
        try {
            return this.facade.getRolesFrom(user);
        }
        catch (PersistenceException e) {
            throw new RuntimePersistenceException((Throwable)e);
        }
    }

    public void logOff() {
        this.currentMandant = null;
    }
}

