/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.context.model;

import de.fhdw.wtf.context.model.AnyValue;
import de.fhdw.wtf.persistence.meta.IntegerValue;
import java.math.BigInteger;

public final class Int
extends AnyValue {
    private final BigInteger value;

    public Int(BigInteger value) {
        this.value = value;
    }

    public Int(IntegerValue value) {
        this(value.getValue());
    }

    public Int(String value) {
        this(new BigInteger(value));
    }

    public Int(long value) {
        this(BigInteger.valueOf(value));
    }

    public Int add(Int summand) {
        return new Int(this.value.add(summand.value));
    }

    public Int sub(Int subtrahend) {
        return new Int(this.value.subtract(subtrahend.value));
    }

    public Int mul(Int factor) {
        return new Int(this.value.multiply(factor.value));
    }

    public Int div(Int divisor) {
        return new Int(this.value.divide(divisor.value));
    }

    public boolean lessEq(Int compareTo) {
        return this.value.compareTo(compareTo.value) <= 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Int) {
            Int other = (Int)obj;
            return this.value.equals(other.value);
        }
        return false;
    }

    public BigInteger getVal() {
        return this.value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value.toString();
    }
}

