package de.fhdw.wtf.context.model.collections.functors;

import java.util.Iterator;
import java.util.Vector;

import de.fhdw.wtf.context.model.Anything;
import de.fhdw.wtf.context.model.collections.Collection;
import de.fhdw.wtf.context.model.collections.ImmutableCollection;
import de.fhdw.wtf.context.model.collections.ImmutableList;
import de.fhdw.wtf.context.model.collections.MutableList;

/**
 * A dummy implementation of MutableList, intended to be used while initializing a service.
 *
 * @param <T>
 *            The underlying element type.
 */
public class DummyCollection<T extends Anything> extends MutableList<T> {
	
	@Override
	public Collection<T> union(final Collection<? extends T> otherCollection) {
		return this;
	}
	
	@Override
	public boolean contains(final T element) {
		return false;
	}
	
	@Override
	public boolean isEmpty() {
		return false;
	}
	
	@Override
	public Iterator<T> iterator() {
		return new Vector<T>().iterator();
	}
	
	@Override
	public void insert(final T element) {
		// do nothing
	}
	
	@Override
	public void apply(final Procedure<T> procedure) {
		// do nothing
	}
	
	@Override
	public void remove(final Predicate<T> predicate) {
		// do nothing
	}
	
	@Override
	public ImmutableCollection<T> copy() {
		return new ImmutableList<>();
	}
	
}
