/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.context.core;

import de.fhdw.wtf.context.core.ApplicationContainer;
import de.fhdw.wtf.context.core.Logger;
import de.fhdw.wtf.context.core.ObjectFactoryProvider;
import de.fhdw.wtf.context.exception.DatabaseManagerFactoryNotInstantiableException;
import de.fhdw.wtf.context.exception.FrameworkException;
import de.fhdw.wtf.context.model.collections.PersistentList;
import de.fhdw.wtf.context.model.collections.PersistentListFactory;
import de.fhdw.wtf.context.model.collections.PersistentMap;
import de.fhdw.wtf.context.model.collections.PersistentMapFactory;
import de.fhdw.wtf.persistence.exception.ClassFacadeUninitializedException;
import de.fhdw.wtf.persistence.exception.PersistenceException;
import de.fhdw.wtf.persistence.exception.TypeOrAssociationNotFoundException;
import de.fhdw.wtf.persistence.facade.ClassFacade;
import de.fhdw.wtf.persistence.facade.DatabaseManager;
import de.fhdw.wtf.persistence.facade.DatabaseManagerFactory;
import de.fhdw.wtf.persistence.facade.TypeManager;
import de.fhdw.wtf.persistence.utils.PropertiesReaderFactory;
import de.fhdw.wtf.persistence.utils.PropertiesReaderFile;
import java.io.IOException;
import java.lang.reflect.Modifier;

public abstract class ApplicationStarter {
    private static final String PACKAGE_DELIMITER = ".";
    private static final String SOURCE_PACKAGE_OF_DATABASE_MANAGER_FACTORIES = "de.fhdw.wtf.persistence.facade";
    public static final Object ORACLE_DATABASE_MANAGER_FACTORY_NAME = "OracleDatabaseManagerFactory";

    public void startStandalone() {
        this.start(this.getResourcesPathJava());
    }

    public void startServer() {
        this.start(this.getResourcesPathServer());
    }

    public void start(String resourcesPath) {
        PropertiesReaderFile prop;
        try {
            prop = new PropertiesReaderFile();
            prop.initialize(resourcesPath + "/" + this.getApplicationConfigFileName());
        }
        catch (Exception e) {
            throw new FrameworkException(e.getMessage());
        }
        try {
            this.initializeLogger();
            ApplicationContainer.getInstance().setAppName(prop.getProperty("application-name"));
            ApplicationContainer.getInstance().setUsedDatabaseManagerFactoryName(prop.getProperty("database"));
            this.initializeDatabase(resourcesPath, ApplicationContainer.getInstance().getUsedDatabaseManagerFactoryName());
            this.initializeRuntimePersistence();
            this.initializeFactories();
            this.registerActivities();
        }
        catch (PersistenceException e) {
            throw new FrameworkException(e.getMessage());
        }
        catch (IOException e) {
            throw new FrameworkException(e.getMessage());
        }
    }

    protected abstract void registerActivities();

    public void stop() {
        try {
            ApplicationContainer.getInstance().getDatabaseManager().disconnect();
        }
        catch (PersistenceException e) {
            throw new FrameworkException(e.getMessage());
        }
    }

    private void initializeFactories() throws ClassFacadeUninitializedException, TypeOrAssociationNotFoundException {
        ObjectFactoryProvider factoryProvider = ObjectFactoryProvider.instance();
        ApplicationContainer.getInstance().setFactoryProvider(factoryProvider);
        TypeManager typeManager = ApplicationContainer.getInstance().getDatabaseManager().getClassFacade().getTypeManager();
        try {
            factoryProvider.registerTypeFactory(typeManager, PersistentList.class.getName(), new PersistentListFactory());
        }
        catch (TypeOrAssociationNotFoundException typeOrAssociationNotFoundException) {
            // empty catch block
        }
        try {
            factoryProvider.registerTypeFactory(typeManager, PersistentMap.class.getName(), new PersistentMapFactory());
        }
        catch (TypeOrAssociationNotFoundException typeOrAssociationNotFoundException) {
            // empty catch block
        }
        this.registerTypeFactories(factoryProvider, typeManager);
    }

    protected abstract void registerTypeFactories(ObjectFactoryProvider var1, TypeManager var2) throws TypeOrAssociationNotFoundException;

    private void initializeRuntimePersistence() throws PersistenceException {
        ClassFacade classFacade = ApplicationContainer.getInstance().getDatabaseManager().getClassFacade();
        classFacade.initializeForRuntime();
    }

    private void initializeLogger() {
        ApplicationContainer.getInstance().setLogger(Logger.getInstance());
    }

    private void initializeDatabase(String resourcesPath, String databaseManagerFactoryClassName) throws IOException, PersistenceException {
        DatabaseManager database;
        Class<?> newClass;
        try {
            newClass = Class.forName("de.fhdw.wtf.persistence.facade." + databaseManagerFactoryClassName);
        }
        catch (ClassNotFoundException e) {
            throw new DatabaseManagerFactoryNotInstantiableException(e.getMessage());
        }
        if (Modifier.isAbstract(newClass.getModifiers()) || !DatabaseManagerFactory.class.isAssignableFrom(newClass)) {
            throw new DatabaseManagerFactoryNotInstantiableException("The given class is abstract or not a descendant of DatabaseManagerFactory.");
        }
        try {
            database = ((DatabaseManagerFactory)newClass.newInstance()).getInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new DatabaseManagerFactoryNotInstantiableException(e.getMessage());
        }
        database.setConnectionConstantsFromFile(PropertiesReaderFactory.getInstance().getPropertiesReaderOracle());
        database.connect();
        ApplicationContainer.getInstance().setDatabaseManager(database);
    }

    protected abstract String getResourcesPathJava();

    protected abstract String getResourcesPathServer();

    protected abstract String getApplicationConfigFileName();

    protected abstract String getDatabaseConfigFileName();

    protected abstract String getModelPrefix();
}

