package de.fhdw.wtf.context.model.collections.functors;

import de.fhdw.wtf.context.model.Anything;

/**
 * This Interface represents a Function f: T -> U.
 * 
 * @param <T>
 *            The Type of the given input, must be a subclass of Anything.
 * @param <U>
 *            The Type of the output of the function, must be a subclass of Anything.
 */
public interface Function<T extends Anything, U extends Anything> {
	
	/**
	 * A Function which takes a parameter of type T und provides a value of type U.
	 * 
	 * @param x
	 *            The parameter.
	 * @return A value of Type U.
	 */
	U f(T x);
	
}
