package de.fhdw.wtf.context.model;

import de.fhdw.wtf.context.core.ObjectFactory;
import de.fhdw.wtf.context.exception.FrameworkException;
import de.fhdw.wtf.persistence.meta.Object;
import de.fhdw.wtf.persistence.meta.UserObject;

/**
 * This class represents the abstract superclass to all factories for user defined types.
 * 
 */
public abstract class UserObjectFactory extends ObjectFactory {
	
	@Override
	public Anything createObject(final Object object) {
		if (object instanceof UserObject) {
			final UserObject userObject = (UserObject) object;
			final IAnyType result = this.createSpecificUserType(userObject);
			return result;
		} else {
			throw new FrameworkException("UserObjectFactory.createObject() called on object of type "
					+ object.getClass().getName());
		}
	}
	
	/**
	 * The method creates a new instance of a User Type.
	 * 
	 * @param userObject
	 *            The underlying UserObject. This must be passed to the user type's constructor and passed down to
	 *            AnyType.
	 * @return A user type which is a subtype of AnyType.
	 */
	protected abstract IAnyType createSpecificUserType(final UserObject userObject);
	
}
