/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.context.core;

import de.fhdw.wtf.context.core.Context;
import de.fhdw.wtf.context.core.NoContext;

public final class TransactionManager {
    private static ThreadLocal<Context> contextHolder = new ThreadLocal<Context>(){

        @Override
        protected Context initialValue() {
            return new NoContext();
        }
    };

    private TransactionManager() {
    }

    public static Context getContext() {
        return contextHolder.get();
    }

    public static void setContext(Context context) {
        contextHolder.set(context);
    }

    public static void commit() {
        contextHolder.get().commit();
        contextHolder.set(new NoContext());
    }

    public static void rollback() {
        contextHolder.get().rollback();
        contextHolder.set(new NoContext());
    }
}

