package de.fhdw.wtf.context.core;

import java.math.BigInteger;
import java.util.Collection;

import de.fhdw.wtf.context.exception.OutOfScopeException;
import de.fhdw.wtf.persistence.facade.TypeManager;
import de.fhdw.wtf.persistence.meta.Link;
import de.fhdw.wtf.persistence.meta.MapLink;
import de.fhdw.wtf.persistence.meta.Object;
import de.fhdw.wtf.persistence.meta.UnidirectionalLink;
import de.fhdw.wtf.persistence.meta.UserObject;
import de.fhdw.wtf.persistence.utils.Tuple;

/**
 * An implementation of a Context to represent the absence of a Context. Every call to this Context will result in an
 * exception except from methods like commit, savePoint or rollback. These methods will simply have no effect.
 */
public class NoContext extends Context {
	
	/**
	 * Creates a new NoContext.
	 */
	public NoContext() {
	}
	
	@Override
	public Collection<UserObject> find(final String associationName, final String value) {
		this.throwException();
		return null;
	}
	
	@Override
	public Collection<UserObject> find(final String associationName, final BigInteger value) {
		this.throwException();
		return null;
	}
	
	@Override
	public Collection<Tuple<UnidirectionalLink, UserObject>> inverseGet(final String associationName,
			final UserObject object) {
		this.throwException();
		return null;
	}
	
	@Override
	public Collection<Tuple<UnidirectionalLink, Object>> get(final UserObject object, final String associationName) {
		this.throwException();
		return null;
	}
	
	@Override
	public Collection<Tuple<MapLink, Object>> get(final UserObject object,
			final String associationName,
			final String key) {
		this.throwException();
		return null;
	}
	
	@Override
	public Collection<Tuple<MapLink, Object>> get(final UserObject object,
			final String associationName,
			final BigInteger key) {
		this.throwException();
		return null;
	}
	
	@Override
	public Collection<Tuple<MapLink, Object>> get(final UserObject object,
			final String associationName,
			final UserObject key) {
		this.throwException();
		return null;
	}
	
	@Override
	public UserObject create(final String typeName) {
		this.throwException();
		return null;
	}
	
	@Override
	public UnidirectionalLink set(final UserObject object, final String associationName, final String val) {
		this.throwException();
		return null;
	}
	
	@Override
	public UnidirectionalLink set(final UserObject object, final String associationName, final BigInteger val) {
		this.throwException();
		return null;
	}
	
	@Override
	public UnidirectionalLink set(final UserObject object, final String associationName, final UserObject target) {
		this.throwException();
		return null;
	}
	
	@Override
	public MapLink put(final UserObject owner, final String associationName, final UserObject target, final String key) {
		this.throwException();
		return null;
	}
	
	@Override
	public MapLink put(final UserObject owner, final String associationName, final BigInteger target, final String key) {
		this.throwException();
		return null;
	}
	
	@Override
	public MapLink put(final UserObject owner, final String associationName, final String target, final String key) {
		this.throwException();
		return null;
	}
	
	@Override
	public MapLink put(final UserObject owner,
			final String associationName,
			final UserObject target,
			final BigInteger key) {
		this.throwException();
		return null;
	}
	
	@Override
	public MapLink put(final UserObject owner,
			final String associationName,
			final BigInteger target,
			final BigInteger key) {
		this.throwException();
		return null;
	}
	
	@Override
	public MapLink put(final UserObject owner, final String associationName, final String target, final BigInteger key) {
		this.throwException();
		return null;
	}
	
	@Override
	public MapLink put(final UserObject owner,
			final String associationName,
			final UserObject target,
			final UserObject key) {
		this.throwException();
		return null;
	}
	
	@Override
	public MapLink put(final UserObject owner,
			final String associationName,
			final BigInteger target,
			final UserObject key) {
		this.throwException();
		return null;
	}
	
	@Override
	public MapLink put(final UserObject owner, final String associationName, final String target, final UserObject key) {
		this.throwException();
		return null;
	}
	
	@Override
	public void commit() {
		// nothing to do
	}
	
	@Override
	public void rollback() {
		// nothing to do
	}
	
	@Override
	public void savePoint() {
		// nothing to do
	}
	
	@Override
	public void rollbackToSavePoint() {
		// nothing to do
	}
	
	@Override
	public void unset(final Link toUnset) {
		this.throwException();
	}
	
	@Override
	public TypeManager getTypeManager() {
		this.throwException();
		return null;
	}
	
	@Override
	public Collection<UserObject> getObjectsByType(final String typeName) {
		this.throwException();
		return null;
	}
	
	@Override
	public UserObject checkout(final long object) {
		this.throwException();
		return null;
	}
	
	/**
	 * Throws an exception of type OutOfScopeException.
	 */
	private void throwException() {
		final OutOfScopeException excpetion = new OutOfScopeException(Thread.currentThread().getName());
		Logger.getInstance().logError(excpetion.getMessage());
		throw excpetion;
	}
}
