package de.fhdw.wtf.persistence.meta;

import de.fhdw.wtf.persistence.exception.NotValidInputException;

/**
 * A class to represent a connection between three objects in the database. The UnidirectionalLink itself is an instance
 * of an association3.
 * 
 */
public class MapLink extends Link {
	
	/**
	 * The hashmap-key object.
	 */
	private final Object key;
	
	/**
	 * Getter for the key of this UnidirectionalLink.
	 * 
	 * @return Provides an Object, which is the key of this link.
	 */
	public Object getKey() {
		return this.key;
	}
	
	/**
	 * The type of this link.
	 */
	private final MapAssociation instanceOf;
	
	@Override
	public MapAssociation getInstanceOf() {
		return this.instanceOf;
	}
	
	/**
	 * Constructor for a new UnidirectionalLink, it should only be called by the Object Facade or Junit Test to
	 * guarantee a valid consistency with the database.
	 * 
	 * @param id
	 *            The Id of the UnidirectionalLink, determined by the database.
	 * @param owner
	 *            The owner of the this UnidirectionalLink. A User Object.
	 * @param target
	 *            The target of this link. An Object.
	 * @param key
	 *            The hashmap-key of this link. An Object.
	 * @param instanceOf
	 *            The type of this link.
	 * @throws NotValidInputException
	 */
	public MapLink(final long id,
			final UserObject owner,
			final Object target,
			final Object key,
			final MapAssociation instanceOf) throws NotValidInputException {
		super(id, owner, target);
		this.key = key;
		this.instanceOf = instanceOf;
		
	}
	
	@Override
	public String toString() {
		return "MapLink<" + this.getId() + ">";
	}
	
	@Override
	public boolean equals(final java.lang.Object other) {
		if (!(other instanceof MapLink)) {
			return false;
		}
		
		final MapLink link = (MapLink) other;
		return super.equals(link) && this.getInstanceOf().equals(link.getInstanceOf())
				&& this.getKey().equals(link.getKey());
	}
	
	@Override
	public int hashCode() {
		return super.hashCode() ^ this.instanceOf.hashCode() ^ this.key.hashCode();
	}
}
