package de.fhdw.wtf.persistence.meta;

/**
 * Represents the specialization-relationship between an ancestor and its descendant.
 */
public class Specialization {
	
	/**
	 * The ancestor of this specialization-relationship.
	 */
	private final Type ancestor;
	/**
	 * The descendant of this specialization-relationship.
	 */
	private final Type descendant;
	
	/**
	 * Instantiates a new specialization-object with ancestor and descendant.
	 * 
	 * @param ancestor
	 *            the ancestor of this specialization-relationship.
	 * @param descendant
	 *            the descendant of this specialization-relationship.
	 */
	public Specialization(final Type ancestor, final Type descendant) {
		this.ancestor = ancestor;
		this.descendant = descendant;
	}
	
	/**
	 * @return the ancestor of this specialization-relationship.
	 */
	public Type getAncestor() {
		return this.ancestor;
	}
	
	/**
	 * @return the descendant of this specialization-relationship.
	 */
	public Type getDescendant() {
		return this.descendant;
	}
	
	@Override
	public boolean equals(final java.lang.Object obj) {
		if (obj instanceof Specialization) {
			final Specialization objAsSpecialization = (Specialization) obj;
			return objAsSpecialization.getAncestor().isTheSameAs(this.getAncestor())
					&& objAsSpecialization.getDescendant().isTheSameAs(this.getDescendant());
		}
		return false;
	}
	
	/**
	 * Constant 1 for calculating hashCode.
	 */
	private static final int HASHCODE_PRIME_FACTOR_1 = 13;
	/**
	 * Constant 2 for calculating hashCode.
	 */
	private static final int HASHCODE_PRIME_FACTOR_2 = 27;
	/**
	 * Constant 2 for calculating hashCode.
	 */
	private static final int HASHCODE_PRIME_FACTOR_3 = 42;
	
	@Override
	public int hashCode() {
		int code = HASHCODE_PRIME_FACTOR_3;
		
		code += HASHCODE_PRIME_FACTOR_1 * this.getAncestor().hashCode();
		code += HASHCODE_PRIME_FACTOR_2 * this.getDescendant().hashCode();
		
		return code;
	}
	
}
