/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.persistence.facade;

import de.fhdw.wtf.persistence.exception.MandantNotLoggedInException;
import de.fhdw.wtf.persistence.exception.NameAlreadyExistsException;
import de.fhdw.wtf.persistence.exception.ObjectNotFoundException;
import de.fhdw.wtf.persistence.exception.OtherSQLException;
import de.fhdw.wtf.persistence.exception.PersistenceException;
import de.fhdw.wtf.persistence.exception.WrongPasswordException;
import de.fhdw.wtf.persistence.facade.AuthorizationFacade;
import de.fhdw.wtf.persistence.facade.OracleDatabaseManager;
import de.fhdw.wtf.persistence.meta.Mandant;
import de.fhdw.wtf.persistence.meta.Role;
import de.fhdw.wtf.persistence.meta.User;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import oracle.jdbc.internal.OracleCallableStatement;

public class OracleAuthorizationFacadeImplementation
implements AuthorizationFacade {
    private boolean mandantLoggedIn;
    private Mandant currentMandant;
    private final String salt;
    private final OracleDatabaseManager database;
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    public OracleAuthorizationFacadeImplementation(String salt, OracleDatabaseManager database) {
        this.salt = salt;
        this.database = database;
        this.currentMandant = null;
        this.mandantLoggedIn = false;
    }

    @Override
    public void logIn(Mandant mandant) throws PersistenceException {
        this.currentMandant = mandant;
        if (!this.isPasswordCorrect(this.currentMandant.getId(), "root", this.currentMandant.getRootPassword())) {
            throw new WrongPasswordException(mandant.getId(), "root");
        }
        try (CallableStatement call = this.database.getConnection().prepareCall("begin ? := accountfacade.getAllUsersForMandant(?); end;");){
            call.registerOutParameter(1, -10);
            call.setString(2, this.currentMandant.getId());
            call.execute();
            try (ResultSet result = ((OracleCallableStatement)call).getCursor(1);){
                while (result.next()) {
                    String name = result.getString(3);
                    if (name.equals("root")) continue;
                    User entry = new User(result.getLong(1), name, result.getString(2));
                    this.currentMandant.addUser(entry);
                }
            }
            this.mandantLoggedIn = true;
        }
        catch (SQLException e) {
            throw new OtherSQLException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isPasswordCorrect(String mandant, String username, String password) throws PersistenceException {
        try {
            MessageDigest message = MessageDigest.getInstance("MD5");
            message.update((password + this.salt).getBytes());
            String hashedPW = OracleAuthorizationFacadeImplementation.toHex(message.digest());
            try (CallableStatement call = this.database.getConnection().prepareCall("begin ? := accountfacade.authorize(?,?,?); end;");){
                call.registerOutParameter(1, 2);
                call.setString(2, mandant);
                call.setString(3, username);
                call.setString(4, hashedPW);
                call.execute();
                boolean bl = call.getInt(1) == 1;
                return bl;
            }
            catch (SQLException e) {
                throw new OtherSQLException(e);
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void checkMandantLogIn() throws PersistenceException {
        if (!this.mandantLoggedIn) {
            throw new MandantNotLoggedInException();
        }
    }

    @Override
    public User createUser(String username, String password) throws PersistenceException {
        this.checkMandantLogIn();
        long id = this.createUser(this.currentMandant.getId(), username, password);
        User result = new User(id, username, this.currentMandant.getId());
        this.currentMandant.addUser(result);
        return result;
    }

    @Override
    public void grantRoleToUser(User user, Role role) throws PersistenceException {
        this.checkMandantLogIn();
        try (CallableStatement call = this.database.getConnection().prepareCall("begin accountfacade.addRoleToUser(?,?); end;");){
            call.setLong(1, user.getId());
            call.setLong(2, role.getId());
            call.execute();
        }
        catch (SQLException e) {
            throw new OtherSQLException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Role createRole(String name) throws PersistenceException {
        try (CallableStatement call = this.database.getConnection().prepareCall("begin ? := accountfacade.createRole(?); end;");){
            call.registerOutParameter(1, 2);
            call.setString(2, name);
            call.execute();
            Role role = new Role(call.getLong(1), name);
            return role;
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 20007) {
                throw new NameAlreadyExistsException(e);
            }
            e.printStackTrace();
            throw new OtherSQLException(e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Set<Role> getRolesFrom(User user) throws PersistenceException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long createUser(String mandant, String username, String password) throws PersistenceException {
        try {
            MessageDigest message = MessageDigest.getInstance("MD5");
            message.update((password + this.salt).getBytes());
            String hashedPassword = OracleAuthorizationFacadeImplementation.toHex(message.digest());
            try (CallableStatement call = this.database.getConnection().prepareCall("begin ? := accountfacade.createUser(?,?,?); end;");){
                call.registerOutParameter(1, 2);
                call.setString(2, mandant);
                call.setString(3, username);
                call.setString(4, hashedPassword);
                call.execute();
                long l = call.getLong(1);
                return l;
            }
            catch (SQLException e) {
                if (e.getErrorCode() != 20007) throw new OtherSQLException(e);
                throw new NameAlreadyExistsException(e);
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new Error(e);
        }
    }

    @Override
    public Mandant createMandant(String id, String rootPassword) throws PersistenceException {
        this.createUser(id, "root", rootPassword);
        return new Mandant(id, rootPassword);
    }

    @Override
    public Set<User> getUsers() throws PersistenceException {
        this.checkMandantLogIn();
        return this.currentMandant.getUsers();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public User getUser(String mandant, String name) throws PersistenceException {
        try (CallableStatement call = this.database.getConnection().prepareCall("begin ? := accountfacade.getUser(?,?); end;");){
            Throwable throwable;
            ResultSet resultSet;
            block25: {
                User user;
                block26: {
                    call.registerOutParameter(1, -10);
                    call.setString(2, mandant);
                    call.setString(3, name);
                    call.execute();
                    resultSet = ((OracleCallableStatement)call).getCursor(1);
                    throwable = null;
                    if (!resultSet.next()) break block25;
                    user = new User(resultSet.getLong(1), resultSet.getString(3), resultSet.getString(2));
                    if (resultSet == null) return user;
                    if (throwable == null) break block26;
                    try {
                        resultSet.close();
                        return user;
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                        return user;
                    }
                }
                resultSet.close();
                return user;
            }
            try {
                try {
                    throw new ObjectNotFoundException();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (resultSet == null) throw throwable3;
                if (throwable == null) {
                    resultSet.close();
                    throw throwable3;
                }
                try {
                    resultSet.close();
                    throw throwable3;
                }
                catch (Throwable x2) {
                    throwable.addSuppressed(x2);
                    throw throwable3;
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new OtherSQLException(e);
        }
    }

    @Override
    public Set<Role> listAllRoles() throws PersistenceException {
        HashSet<Role> result = new HashSet<Role>();
        try (CallableStatement call = this.database.getConnection().prepareCall("begin ?:= accountfacade.getRoles; end;");){
            call.registerOutParameter(1, -10);
            call.execute();
            try (ResultSet resultSet = ((OracleCallableStatement)call).getCursor(1);){
                while (resultSet.next()) {
                    result.add(new Role(resultSet.getLong(1), resultSet.getString(2)));
                }
            }
        }
        catch (SQLException e) {
            throw new OtherSQLException(e);
        }
        return result;
    }

    private static String toHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            int v = bytes[i] & 0xFF;
            hexChars[i * 2] = hexArray[v >>> 4];
            hexChars[i * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }
}

