CREATE OR REPLACE PACKAGE ObjectFacade IS

	TYPE TransactionID IS RECORD(
		id NUMBER
	);
	TYPE TransactionIDCollection IS REF CURSOR RETURN TransactionID;

	TYPE IDRecord IS RECORD(
		id NUMBER,
		classid NUMBER
	);
	TYPE IDRecordCollection IS REF CURSOR RETURN IDRecord;

	TYPE LinkObjectRecord IS RECORD(
		linkid NUMBER,
		linkclassid NUMBER,
		objectid NUMBER,
		objectclassid NUMBER
		);
	TYPE LinkObjectRecordCollection IS REF CURSOR RETURN LinkObjectRecord;

	TYPE ObjectRecord IS RECORD(
		objectid NUMBER,
		objectclassid NUMBER
	);
	TYPE ObjectRecordCollection IS REF CURSOR RETURN ObjectRecord;
	
	TYPE LinkUserObjectRecord IS RECORD(
		linkid NUMBER,
		linkclassid NUMBER,
		userobjectid NUMBER,
		userobjectclassid NUMBER
	);
	
	TYPE LinkKeyRecord IS RECORD(
		linkid NUMBER,
		linkclassid NUMBER,
		keyclassid NUMBER,
		keyid NUMBER
	);
	
	TYPE UserObjectRecord IS RECORD(
		userobjectid NUMBER,
		userobjectclassid NUMBER
	);
	TYPE UserObjectRecordCollection IS REF CURSOR RETURN UserObjectRecord;
	
	TYPE ObjectKeyLinkRecord IS RECORD(
		objectid NUMBER,
		objectclassid NUMBER,
		keyid NUMBER,
		keyclassid NUMBER,
		linkid NUMBER,
		linkclassid NUMBER
	);
	TYPE ObjectKeyLinkRecordCollection IS REF CURSOR RETURN ObjectKeyLinkRecord;
	

	TYPE LinkKeyRecordCollection IS REF CURSOR RETURN LinkKeyRecord;

	TYPE LinkUserObjectRecordCollection IS REF CURSOR RETURN LinkUserObjectRecord;
  
	FUNCTION findUserObjectByType(typ NUMBER,trans NUMBER) RETURN IDRecordCollection;
	FUNCTION checkUserObjectOut(obj NUMBER, trans NUMBER) RETURN IDRecordCollection;

	FUNCTION findString(a NUMBER, s VARCHAR2, d TIMESTAMP) RETURN IDRecordCollection;
	FUNCTION findInteger(a NUMBER, i NUMBER, d TIMESTAMP) RETURN IDRecordCollection;

	FUNCTION get(o NUMBER, a NUMBER, d TIMESTAMP) RETURN LinkObjectRecordCollection;
	FUNCTION getMapUO(o NUMBER, a NUMBER, k NUMBER, d TIMESTAMP) RETURN UserObjectRecordCollection;
	FUNCTION getMapStr(o NUMBER, a NUMBER, k VARCHAR2, d TIMESTAMP) RETURN UserObjectRecordCollection;
	FUNCTION getMapInt(o NUMBER, a NUMBER, k NUMBER, d TIMESTAMP) RETURN UserObjectRecordCollection;
	FUNCTION inverseGet(o NUMBER, a NUMBER, d TIMESTAMP) RETURN LinkUserObjectRecordCollection;
	FUNCTION inverseGetMapUO(o NUMBER, a NUMBER, d TIMESTAMP) RETURN ObjectKeyLinkRecordCollection;
	FUNCTION inverseGetMapStr(o VARCHAR2, a NUMBER, d TIMESTAMP) RETURN ObjectKeyLinkRecordCollection;
	FUNCTION inverseGetMapInt(o NUMBER, a NUMBER, d TIMESTAMP) RETURN ObjectKeyLinkRecordCollection;

	FUNCTION findStringTransaction(a NUMBER, s VARCHAR2, trans NUMBER) RETURN IDRecordCollection;
	FUNCTION findIntegerTransaction(a NUMBER, i NUMBER, trans NUMBER) RETURN IDRecordCollection;

	
	FUNCTION getTransactionCursor(o NUMBER, a NUMBER, trans NUMBER) RETURN LinkObjectRecordCollection;
	FUNCTION getTransaction(o NUMBER, a NUMBER, trans NUMBER) RETURN LinkObjectRecordCollection;
	FUNCTION getMapTransactionCursor(o NUMBER, a NUMBER, k NUMBER, trans NUMBER) RETURN ObjectKeyLinkRecordCollection;
	FUNCTION getMapUOTransaction(o NUMBER, a NUMBER, k NUMBER, trans NUMBER) RETURN ObjectKeyLinkRecordCollection;
	FUNCTION getMapStrTransaction(o NUMBER, a NUMBER, k VARCHAR2, trans NUMBER) RETURN ObjectKeyLinkRecordCollection;
	FUNCTION getMapIntTransaction(o NUMBER, a NUMBER, k NUMBER, trans NUMBER) RETURN ObjectKeyLinkRecordCollection;

	FUNCTION inverseGetTransactionCursor(o NUMBER, a NUMBER, trans NUMBER) RETURN LinkUserObjectRecordCollection;
  	FUNCTION inverseGetMapTransactionCursor(o NUMBER, a NUMBER, trans NUMBER) RETURN ObjectKeyLinkRecordCollection;
	FUNCTION inverseGetTransaction(o NUMBER, a NUMBER, trans NUMBER) RETURN LinkUserObjectRecordCollection;
	FUNCTION inverseGetMapUOTransaction(o NUMBER, a NUMBER, trans NUMBER) RETURN ObjectKeyLinkRecordCollection;
	FUNCTION inverseGetMapStrTransaction(o VARCHAR2, a NUMBER, trans NUMBER) RETURN ObjectKeyLinkRecordCollection;
	FUNCTION inverseGetMapIntTransaction(o NUMBER, a NUMBER, trans NUMBER) RETURN ObjectKeyLinkRecordCollection;

	FUNCTION getActiveShortTransaction(trans NUMBER) RETURN NUMBER;
	PROCEDURE insertReadAccessed(versionedObject NUMBER, trans NUMBER);
	PROCEDURE insertModifiedAccessed(versionedObject NUMBER, trans NUMBER);
	PROCEDURE insertDeletedAccessed(versionedObject NUMBER, trans NUMBER);
	
	

	FUNCTION setUO(o NUMBER, a NUMBER, tParam NUMBER, lt NUMBER) RETURN NUMBER;
	FUNCTION setStr(o NUMBER, a NUMBER, stringValue VARCHAR2, lt NUMBER) RETURN NUMBER;
	FUNCTION setInt(o NUMBER, a NUMBER, intValue NUMBER, lt NUMBER) RETURN NUMBER;
	
	FUNCTION putUOUO(o NUMBER, a NUMBER, t NUMBER, k NUMBER, trans NUMBER) RETURN NUMBER;
	FUNCTION putUOStr(o NUMBER, a NUMBER, t NUMBER, k VARCHAR2, trans NUMBER) RETURN NUMBER;
	FUNCTION putUOInt(o NUMBER, a NUMBER, t NUMBER, k NUMBER, trans NUMBER) RETURN NUMBER;
	FUNCTION putStrUO(o NUMBER, a NUMBER, t VARCHAR2, k NUMBER, trans NUMBER) RETURN NUMBER;
	FUNCTION putStrStr(o NUMBER, a NUMBER, t VARCHAR2, k VARCHAR2, trans NUMBER) RETURN NUMBER;
	FUNCTION putStrInt(o NUMBER, a NUMBER, t VARCHAR2, k NUMBER, trans NUMBER) RETURN NUMBER;
	FUNCTION putIntUO(o NUMBER, a NUMBER, t NUMBER, k NUMBER, trans NUMBER) RETURN NUMBER;
	FUNCTION putIntStr(o NUMBER, a NUMBER, t NUMBER, k VARCHAR2, trans NUMBER) RETURN NUMBER;
	FUNCTION putIntInt(o NUMBER, a NUMBER, t NUMBER, k NUMBER, trans NUMBER) RETURN NUMBER;
	
	PROCEDURE unset(l NUMBER, trans NUMBER);

	FUNCTION createUserObject(userType NUMBER, longTA NUMBER) RETURN NUMBER;
	procedure deleteUserObject(userObjectToBeDeleted NUMBER,associatedLongTA NUMBER);

	function isTransactionOpen(tNumber Number) RETURN NUMBER;
	function getConflictingTransactions(tNumber NUMBER) RETURN TransactionIDCollection;
	procedure rollbackTransaction(tNumber Number);
	procedure commitTransaction(tNumber NUmber);
	procedure makeSavePoint(tNumber Number);
	procedure rollbackToSavePoint(tNumber Number);

	function rightDateGreaterEqualsLeftDate(leftDate TIMESTAMP, rightDate TIMESTAMP) RETURN NUMBER;

	FUNCTION getString(s NUMBER) RETURN VARCHAR2;
	FUNCTION getInteger(i NUMBER) RETURN NUMBER;
	FUNCTION getStringObject(s VARCHAR2) RETURN NUMBER; 
	FUNCTION getIntegerObject(i NUMBER) RETURN NUMBER;  

	FUNCTION provideAdhocTransaction RETURN NUMBER;
	FUNCTION getLinkCountOfAssoForOwner(trans NUMBER, o NUMBER, a NUMBER) RETURN NUMBER;
	
	procedure clear;

END ObjectFacade;
