/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.persistence.facade;

import de.fhdw.wtf.persistence.exception.OtherSQLException;
import de.fhdw.wtf.persistence.exception.PersistenceException;
import de.fhdw.wtf.persistence.facade.OracleDatabaseManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.sql.Statement;

public class OracleDataBasePreparator {
    private OracleDatabaseManager databaseManager = OracleDatabaseManager.getInstance();
    private static final String CALL_SUFFIX = " end;";
    private static final String STORED_FUNCTION_PREFIX = "begin ? := ";
    private static final int ORACLE_EXCEPTION_OBJECT_WITH_NAME_ALREADY_EXISTS = 955;
    private static final int ORACLE_EXCEPTION_TABLE_OR_VIEW_DOES_NOT_EXIST = 942;
    private static final int ORACLE_EXCEPTION_SEQUENCER_DOES_NOT_EXIST = 2289;
    private static final int ORACLE_EXCEPTION_OBJECT_DOES_NOT_EXIST = 4043;
    private static final String SCRIPT_ROOT_DIR = "scripts/";
    private static final String PROCEDURE_NAME_CHECK_VALID_TABLE_STRUCTURE = "isValidTableStructureCreated";
    private static final String PROCEDURE_NAME_CHECK_VALID_PROCEDURES = "areProceduresCreated";
    private static final String PACKAGE_NAME_INIT_ROUTINES = "InitRoutines";
    private static final String SCRIPT_NAME_INIT_ROUTINES = "InitRoutines.sql";
    private static final String SCRIPT_NAME_INIT_ROUTINES_BODY = "InitRoutinesBody.sql";
    private static final String SCRIPT_NAME_CREATE_SCHEMA_TABLES = "schemaF.sql";
    private static final String SCRIPT_NAME_CREATE_SCHEMA_EXCEPTION = "userException.sql";
    private static final String SCRIPT_NAME_DROP_SCHEMA = "dropStatements.sql";
    private static final String SCRIPT_NAME_CREATE_PROCEDURES_OBJECT_FACADE = "objectfacade.sql";
    private static final String SCRIPT_NAME_CREATE_PROCEDURES_OBJECT_FACADE_BODY = "objectfacadebody.sql";
    private static final String SCRIPT_NAME_CREATE_PROCEDURES_CLASS_FACADE = "classfacade.sql";
    private static final String SCRIPT_NAME_CREATE_PROCEDURES_CLASS_FACADE_BODY = "classfacadebody.sql";
    private static final String SCRIPT_NAME_CREATE_PROCEDURES_ACCOUNT_FACADE = "accountfacade.sql";
    private static final String SCRIPT_NAME_CREATE_PROCEDURES_ACCOUNT_FACADE_BODY = "accountfacadebody.sql";

    private String readFile(String path, Charset encoding) throws IOException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(path);
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
                stringBuilder.append("\n");
            }
        }
        return stringBuilder.toString();
    }

    private void createInitRoutines() throws PersistenceException, IOException {
        Throwable throwable;
        try {
            throwable = null;
            try (CallableStatement initRoutines = this.databaseManager.getConnection().prepareCall(this.readFile("scripts/InitRoutines.sql", Charset.defaultCharset()));){
                initRoutines.execute();
            }
            catch (Throwable x2) {
                throwable = x2;
                throw x2;
            }
        }
        catch (SQLException e) {
            throw new OtherSQLException(e);
        }
        try {
            throwable = null;
            try (CallableStatement initRoutinesBody = this.databaseManager.getConnection().prepareCall(this.readFile("scripts/InitRoutinesBody.sql", Charset.defaultCharset()));){
                initRoutinesBody.execute();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (SQLException e) {
            throw new OtherSQLException(e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public boolean isTableStructureValid() throws IOException, PersistenceException {
        this.createInitRoutines();
        try {
            Throwable throwable = null;
            try (CallableStatement isValidTableStructureCreated = this.databaseManager.getConnection().prepareCall(STORED_FUNCTION_PREFIX + OracleDatabaseManager.getInstance().getSchemaName() + '.' + PACKAGE_NAME_INIT_ROUTINES + '.' + PROCEDURE_NAME_CHECK_VALID_TABLE_STRUCTURE + ';' + CALL_SUFFIX);){
                isValidTableStructureCreated.registerOutParameter(1, 2);
                try {
                    isValidTableStructureCreated.execute();
                    boolean bl = isValidTableStructureCreated.getInt(1) != 0;
                    return bl;
                }
                catch (SQLException e1) {
                    boolean bl;
                    block19: {
                        block20: {
                            bl = false;
                            if (isValidTableStructureCreated == null) break block19;
                            if (throwable == null) break block20;
                            try {
                                isValidTableStructureCreated.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            break block19;
                        }
                        isValidTableStructureCreated.close();
                    }
                    return bl;
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throw throwable3;
                    }
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new OtherSQLException(e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public boolean areProceduresCreated() throws IOException, PersistenceException {
        this.createInitRoutines();
        try {
            Throwable throwable = null;
            try (CallableStatement areValidProceduresCreated = this.databaseManager.getConnection().prepareCall(STORED_FUNCTION_PREFIX + OracleDatabaseManager.getInstance().getSchemaName() + '.' + PACKAGE_NAME_INIT_ROUTINES + '.' + PROCEDURE_NAME_CHECK_VALID_PROCEDURES + ';' + CALL_SUFFIX);){
                areValidProceduresCreated.registerOutParameter(1, 2);
                try {
                    areValidProceduresCreated.execute();
                    boolean bl = areValidProceduresCreated.getInt(1) != 0;
                    return bl;
                }
                catch (SQLException e1) {
                    boolean bl;
                    block19: {
                        block20: {
                            bl = false;
                            if (areValidProceduresCreated == null) break block19;
                            if (throwable == null) break block20;
                            try {
                                areValidProceduresCreated.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            break block19;
                        }
                        areValidProceduresCreated.close();
                    }
                    return bl;
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throw throwable3;
                    }
                }
            }
        }
        catch (SQLException e1) {
            throw new OtherSQLException(e1);
        }
    }

    public void createWholeSchema() throws PersistenceException, IOException {
        try (Statement statement = this.databaseManager.getConnection().createStatement();){
            String tableSchemaString = this.readFile("scripts/schemaF.sql", Charset.defaultCharset());
            for (String part : tableSchemaString.split(";")) {
                try {
                    statement.execute(part);
                }
                catch (SQLException e) {
                    if (e.getErrorCode() == 955) continue;
                    throw e;
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new OtherSQLException(e);
        }
    }

    public void dropWholeSchema() throws PersistenceException, IOException {
        try (Statement statement = this.databaseManager.getConnection().createStatement();){
            String tableSchemaString = this.readFile("scripts/dropStatements.sql", Charset.defaultCharset());
            for (String part : tableSchemaString.split(";")) {
                try {
                    if (part.startsWith("\n")) {
                        part = part.substring(1);
                    }
                    if (part.isEmpty()) continue;
                    statement.execute(part);
                }
                catch (SQLException e) {
                    if (e.getErrorCode() == 2289 || e.getErrorCode() == 942 || e.getErrorCode() == 4043) continue;
                    throw e;
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new OtherSQLException(e);
        }
    }

    public void createProcedures() throws IOException, PersistenceException {
        Throwable throwable;
        CallableStatement createProceduresCall;
        try {
            createProceduresCall = this.databaseManager.getConnection().prepareCall(this.readFile("scripts/userException.sql", Charset.defaultCharset()));
            throwable = null;
            try {
                createProceduresCall.execute();
            }
            catch (Throwable x2) {
                throwable = x2;
                throw x2;
            }
            finally {
                if (createProceduresCall != null) {
                    if (throwable != null) {
                        try {
                            createProceduresCall.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        createProceduresCall.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new OtherSQLException(e);
        }
        try {
            createProceduresCall = this.databaseManager.getConnection().prepareCall(this.readFile("scripts/classfacade.sql", Charset.defaultCharset()));
            throwable = null;
            try {
                createProceduresCall.execute();
            }
            catch (Throwable x2) {
                throwable = x2;
                throw x2;
            }
            finally {
                if (createProceduresCall != null) {
                    if (throwable != null) {
                        try {
                            createProceduresCall.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        createProceduresCall.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new OtherSQLException(e);
        }
        try {
            createProceduresCall = this.databaseManager.getConnection().prepareCall(this.readFile("scripts/classfacadebody.sql", Charset.defaultCharset()));
            throwable = null;
            try {
                createProceduresCall.execute();
            }
            catch (Throwable x2) {
                throwable = x2;
                throw x2;
            }
            finally {
                if (createProceduresCall != null) {
                    if (throwable != null) {
                        try {
                            createProceduresCall.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        createProceduresCall.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new OtherSQLException(e);
        }
        try {
            createProceduresCall = this.databaseManager.getConnection().prepareCall(this.readFile("scripts/objectfacade.sql", Charset.defaultCharset()));
            throwable = null;
            try {
                createProceduresCall.execute();
            }
            catch (Throwable x2) {
                throwable = x2;
                throw x2;
            }
            finally {
                if (createProceduresCall != null) {
                    if (throwable != null) {
                        try {
                            createProceduresCall.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        createProceduresCall.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new OtherSQLException(e);
        }
        try {
            createProceduresCall = this.databaseManager.getConnection().prepareCall(this.readFile("scripts/objectfacadebody.sql", Charset.defaultCharset()));
            throwable = null;
            try {
                createProceduresCall.execute();
            }
            catch (Throwable x2) {
                throwable = x2;
                throw x2;
            }
            finally {
                if (createProceduresCall != null) {
                    if (throwable != null) {
                        try {
                            createProceduresCall.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        createProceduresCall.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new OtherSQLException(e);
        }
        try {
            createProceduresCall = this.databaseManager.getConnection().prepareCall(this.readFile("scripts/accountfacade.sql", Charset.defaultCharset()));
            throwable = null;
            try {
                createProceduresCall.execute();
            }
            catch (Throwable x2) {
                throwable = x2;
                throw x2;
            }
            finally {
                if (createProceduresCall != null) {
                    if (throwable != null) {
                        try {
                            createProceduresCall.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        createProceduresCall.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new OtherSQLException(e);
        }
        try {
            createProceduresCall = this.databaseManager.getConnection().prepareCall(this.readFile("scripts/accountfacadebody.sql", Charset.defaultCharset()));
            throwable = null;
            try {
                createProceduresCall.execute();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (createProceduresCall != null) {
                    if (throwable != null) {
                        try {
                            createProceduresCall.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        createProceduresCall.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new OtherSQLException(e);
        }
    }
}

